// MainViewDlg.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "MainViewDlg.h"
#include "Include/CommonFun.h"
#include "Include/CLS_NetAdmin_Interface.h"
#include "Include/CLS_NVDSDK_Interface.h"
#include "Logon.h"
#include "DeviceCtrl.h"
#include "NvsInfo.h"
#include "Include/IniFile.h"
#include "PWDChangeDlg.h"
#include "Include/Innerdef.h"
#include "SearchNVS.h"
#include <share.h>
#include "DecCtrlClientTypes.h"
#include <process.h> 
#include "td_mp4.h"
#include "CLS_MP4Operation.h"
#include "RetValue.h"
#include "CLS_PsFileReader.h"
#define MSG_MAIN_NOTIFY			(WM_USER + 1004)
#define MSG_CHANGE_PARAM_NOTIFY	(WM_USER + 1005)

#define MSG_FIND_DEVICE			(WM_USER + 1100)

#define PUSH_PSSTREAM
#ifdef PUSH_PSSTREAM
#define  MAX_FRAME_SIZE		1440
#else
#define  MAX_FRAME_SIZE		3*1024*1024
#endif

#define LOCAL_FILETYPE_SDV			0
#define LOCAL_FILETYPE_MP4			1

#define MAX_SEND_TIMES  1000

CMainViewDlg* CMainViewDlg::s_pSelf = NULL;
WORD g_wLanguage = MAKELANGID(LANG_ENGLISH,SUBLANG_ENGLISH_US);
CString g_strInstDir = "";
static char s_cPushBuffer[MAX_FRAME_SIZE];

//#define TEST_RAW_STREAM

// CMainViewDlg dialog
IMPLEMENT_DYNAMIC(CMainViewDlg, CDialog)

int CalculateVideoSize(S_header* _pfileHeader)
{
	if (NULL == _pfileHeader)
	{
		return -1;
	}

	int iVideoSize = VIDEO_FD1;
	if(_pfileHeader->Width == 1920)
	{
		//1080p
		iVideoSize = VIDEO_HD_1080P;
	}
	else if (_pfileHeader->Width == 1600)
	{
		//QXVGA
		iVideoSize = VIDEO_HD_QXVGA;
	}
	else if(_pfileHeader->Width == 1280)
	{  
		if (_pfileHeader->Height == 720)
		{
			//720P
			iVideoSize = VIDEO_HD_720P;
		}
		else if (_pfileHeader->Height == 960)
		{
			//960P
			iVideoSize = VIDEO_HD_960P;
		}	
	}
	else if((_pfileHeader->Width == 704) || (_pfileHeader->Width == 720))
	{
		if(_pfileHeader->Height > 288)
		{   //D1
			iVideoSize =VIDEO_FD1;
		}
		else
		{   //HD1
			iVideoSize =VIDEO_HD1;
		}
	}
	else if(_pfileHeader->Width == 352)
	{   //CIF/HCIF
		if(_pfileHeader->Height > 144)
		{
			iVideoSize =VIDEO_FCIF;
		}
		else
		{
			iVideoSize =VIDEO_HCIF;
		}
	}
	else if(_pfileHeader->Width == 640)
	{   //VGA
		if(_pfileHeader->Height > 240)
		{
			iVideoSize =VIDEO_VGA;
		}
		else
		{
			iVideoSize =VIDEO_HVGA;
		}
	}
	else if(_pfileHeader->Width == 320)
	{   //QVGA
		iVideoSize =VIDEO_QVGA;
	}
	else if(_pfileHeader->Width < 352)
	{   //QCIF
		iVideoSize =VIDEO_QCIF;
	}
	else if(_pfileHeader->Width == 2048)
	{   //300W
		iVideoSize = VIDEO_HD_QXGA;
	}
	else if(_pfileHeader->Width == 960)
	{   
		if (_pfileHeader->Height == 540)
		{
			//QHD
			iVideoSize = QHD;
		}
		else if (_pfileHeader->Height == 576)
		{
			//960H
			iVideoSize = VZ_960H;
		}
	}
	else if(_pfileHeader->Width == 2448)
	{   //500W(1)
		iVideoSize = VZ_5MA;
	}
	else if(_pfileHeader->Width == 2560)
	{   
		if (_pfileHeader->Height == 1920)
		{
			//500W(2)
			iVideoSize = VZ_5M;
		}
		else if (_pfileHeader->Height == 2048)
		{
			//500W(3)
			iVideoSize = VZ_QSXGA;
		}
	}
	else if (_pfileHeader->Width == 720 && _pfileHeader->Height == 1280)
	{
		iVideoSize = F720P_9_16;
	}
	else if (_pfileHeader->Width == 1080 && _pfileHeader->Height == 1920)
	{
		iVideoSize = F1080P_9_16;
	}
	else
	{
		iVideoSize = VIDEO_FD1;
	}

	return iVideoSize;
}

CMainViewDlg::CMainViewDlg(CWnd* pParent /*=NULL*/)
: CDialog(CMainViewDlg::IDD, pParent),
m_pDlgPicSnap(NULL)
{
	s_pSelf = this;
	m_VecDecoder.clear();
	g_wLanguage = (WORD)GetThreadLocale();
	m_pDlgSetting = NULL;
	m_pDlgSearchNVS = NULL;

	m_iIsOCX = 0;
	m_bAddNVSing = false;

	m_hPushThread = NULL;
	m_dwThreadID = -1;
	m_bPushFlag = false;

	m_iLastID = -1;
	m_iLastChannel = -1;
	m_iLastPos = -1;
	m_bAlreadyTipErr = false;

	for (int i = 0; i < DEC_MAX_PORT_NUM; i++)
	{
		m_iPortAlarm[i] = 0;
	}
	
	m_brAlarmColor.CreateSolidBrush(PORT_ALARM_COLOR);
	m_brDisAlarmColor.CreateSolidBrush(PORT_DISALARM_COLOR);
	::InitializeCriticalSection(&m_csPush);
	m_hPushThread = NULL;
	m_bRunPush = FALSE;
	InitPushStream();
	
}

CMainViewDlg::~CMainViewDlg()
{
	m_hPushThread = NULL;
	m_dwThreadID = -1;
	m_bPushFlag = false;

	m_iLastID = -1;
	m_iLastChannel = -1;
	m_bAlreadyTipErr = false;
	m_iLastPos = -1;
	::DeleteCriticalSection(&m_csPush);

}

void CMainViewDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TREE_DECODER, m_tvDecoder);
	DDX_Control(pDX, IDC_LIST_NVS, m_lstNvs);
	DDX_Control(pDX, IDC_COMBO_POS, m_cboPos);
	DDX_Control(pDX,IDC_CHECK_LAST_FRAME,m_chkLastFrame);
	DDX_Control(pDX, IDC_CHECK_ENCRYPTKEY, m_chkEncryptKey);
	DDX_Control(pDX, IDC_EDIT_ENCRYPT, m_edtEncryptKey);
	DDX_Control(pDX, IDC_BTN_SET_UP, m_btnSetUp);
	DDX_Control(pDX, IDC_BTN_SET_DOWN, m_btnSetDown);
	DDX_Control(pDX, IDC_COMBO_SIGNAL__PICTURE, m_cboSinglePic);
	DDX_Control(pDX, IDC_COMBO_SDK_WORK_MODE, m_cboSdkWorkMode);
	DDX_Control(pDX, IDC_CHECK_CFG, m_chk_SaveCfg);
	DDX_Control(pDX, IDC_CHECK_PUSH_PS_STREAM, m_chkPsStream);
}

BEGIN_MESSAGE_MAP(CMainViewDlg, CDialog)
	//ON_MESSAGE(MSG_EVENT,&CMainViewDlg::OnMainMsg)
	ON_MESSAGE(MSG_MAIN_NOTIFY,&CMainViewDlg::OnMainNotify)
	ON_MESSAGE(MSG_CHANGE_PARAM_NOTIFY,&CMainViewDlg::OnChangeParamNotify)
	ON_MESSAGE(MSG_FIND_DEVICE,&CMainViewDlg::OnFindDevice)

	ON_MESSAGE(MSG_ADDNVSITEM, &CMainViewDlg::OnAddNVSMsg)
	ON_WM_TIMER()
	ON_WM_DESTROY()
	ON_WM_CTLCOLOR()
	ON_CBN_SELCHANGE(IDC_COMBO_POS, &CMainViewDlg::OnCbnSelchangeComboPos)
	ON_BN_CLICKED(IDC_BUTTON_MANUAL_ADD, &CMainViewDlg::OnBnClickedButtonManualAdd)
	ON_BN_CLICKED(IDC_BUTTON_AUTO_SEARCH, &CMainViewDlg::OnBnClickedButtonAutoSearch)
	ON_BN_CLICKED(IDC_BUTTON_CTRL, &CMainViewDlg::OnBnClickedButtonCtrl)
	ON_BN_CLICKED(IDC_BUTTON_ADD, &CMainViewDlg::OnBnClickedButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_MODIFY, &CMainViewDlg::OnBnClickedButtonModify)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, &CMainViewDlg::OnBnClickedButtonDelete)
	ON_BN_CLICKED(IDC_BUTTON_CONNECT, &CMainViewDlg::OnBnClickedButtonConnect)
	ON_BN_CLICKED(IDC_BUTTON_DISCONNECT, &CMainViewDlg::OnBnClickedButtonDisconnect)
	ON_BN_CLICKED(IDC_BUTTON_AUDIO, &CMainViewDlg::OnBnClickedButtonAudio)
	ON_BN_CLICKED(IDC_BUTTON_TALK, &CMainViewDlg::OnBnClickedButtonTalk)
	ON_BN_CLICKED(IDC_BUTTON_AUTO_SWITCH, &CMainViewDlg::OnBnClickedButtonAutoSwitch)
	ON_BN_CLICKED(IDC_BUTTON_PUSH_STREAM, &CMainViewDlg::OnBnClickedButtonPushStream)
	ON_BN_CLICKED(IDC_BUTTON_ADVANCE_ADD, &CMainViewDlg::OnBnClickedButtonIntelligentAdd)
	ON_NOTIFY(NM_RCLICK, IDC_TREE_DECODER, &CMainViewDlg::OnNMRClickTreeDecoder)
	ON_NOTIFY(NM_DBLCLK, IDC_TREE_DECODER, &CMainViewDlg::OnNMDblclkTreeDecoder)
	ON_NOTIFY(TVN_SELCHANGED, IDC_TREE_DECODER, &CMainViewDlg::OnTvnSelchangedTreeDecoder)
	ON_NOTIFY(NM_RCLICK, IDC_LIST_NVS, &CMainViewDlg::OnNMRClickListNvs)
	ON_NOTIFY(NM_DBLCLK, IDC_LIST_NVS, &CMainViewDlg::OnNMDblclkListNvs)
	ON_COMMAND(ID_LOGON, &CMainViewDlg::OnLogon)
	ON_COMMAND(ID_LOGOFF, &CMainViewDlg::OnLogoff)
	ON_COMMAND(ID_SET, &CMainViewDlg::OnSet)
	ON_COMMAND(ID_PASSWORD, &CMainViewDlg::OnPassword)
	ON_COMMAND(ID_REBOOT, &CMainViewDlg::OnReboot)
	ON_COMMAND(ID_DELETE, &CMainViewDlg::OnDelete)
	ON_COMMAND(ID_NVS_CONNECT, &CMainViewDlg::OnNvsConnect)
	ON_COMMAND(ID_NVS_DISCONNECT, &CMainViewDlg::OnNvsDisconnect)
	ON_COMMAND(ID_NVS_MODIFY, &CMainViewDlg::OnNvsModify)
	ON_COMMAND(ID_NVS_DELETE, &CMainViewDlg::OnNvsDelete)
	ON_COMMAND(ID_SCREEN_1, &CMainViewDlg::OnScreen1)
	ON_COMMAND(ID_SCREEN_2, &CMainViewDlg::OnScreen2)
	ON_COMMAND(ID_SCREEN_4, &CMainViewDlg::OnScreen4)
	ON_COMMAND(ID_SCREEN_0, &CMainViewDlg::OnScreen0)
	ON_COMMAND(ID_SCREEN_3, &CMainViewDlg::OnScreen3)
	ON_COMMAND(ID_SCREEN_8, &CMainViewDlg::OnScreen8)
	ON_COMMAND(ID_SCREEN_6, &CMainViewDlg::OnScreen6)
	ON_COMMAND(ID_SCREEN_9, &CMainViewDlg::OnScreen9)
	ON_COMMAND(ID_SCREEN_16, &CMainViewDlg::OnScreen16)
	ON_COMMAND(ID_SCREEN_10, &CMainViewDlg::OnScreen10)
	ON_COMMAND(ID_SCREEN_13, &CMainViewDlg::OnScreen13)
	ON_COMMAND(ID_SCREEN_20A, &CMainViewDlg::OnScreen20A)
	ON_COMMAND(ID_SCREEN_20B, &CMainViewDlg::OnScreen20B)
	ON_COMMAND(ID_SCREEN_25, &CMainViewDlg::OnScreen25)
	ON_COMMAND(ID_SCREEN_36, &CMainViewDlg::OnScreen36)
	ON_COMMAND(ID_SCREEN_40, &CMainViewDlg::OnScreen40)
	ON_COMMAND(ID_SCREEN_64, &CMainViewDlg::OnScreen64)
	ON_COMMAND(ID_SCREEN_81, &CMainViewDlg::OnScreen81)
	ON_COMMAND(ID_SCREEN_100, &CMainViewDlg::OnScreen100)
	ON_BN_CLICKED(IDC_CHECK_ENCRYPTKEY, &CMainViewDlg::OnBnClickedCheckEncryptkey)
	ON_BN_CLICKED(IDC_BUTTON_FASTPLAY, &CMainViewDlg::OnBnClickedButtonFastplay)
	ON_BN_CLICKED(IDC_BUTTON_SLOWPLAY, &CMainViewDlg::OnBnClickedButtonSlowplay)
	ON_WM_PAINT()
	ON_BN_CLICKED(IDC_BTN_SET_UP, &CMainViewDlg::OnBnClickedBtnSetUp)
	ON_BN_CLICKED(IDC_BTN_SET_DOWN, &CMainViewDlg::OnBnClickedBtnSetDown)
	ON_CBN_SELCHANGE(IDC_COMBO_SIGNAL__PICTURE, &CMainViewDlg::OnCbnSelchangeComboSignal)
	ON_BN_CLICKED(IDC_BUTTON_SDK_WORK_MODE, &CMainViewDlg::OnBnClickedButtonSdkWorkMode)
	ON_BN_CLICKED(IDC_BUTTON_SYNC_LOOPCTRL, &CMainViewDlg::OnBnClickedButtonSyncLoopctrl)
	ON_BN_CLICKED(IDC_BTN_PICSNAP, &CMainViewDlg::OnBnClickedBtnPicsnap)
END_MESSAGE_MAP()

// CMainViewDlg message handlers

HBRUSH CMainViewDlg::OnCtlColor(CDC* pDC, CWnd* pWnd, UINT nCtlColor)
{
	HBRUSH hbr = CDialog::OnCtlColor(pDC, pWnd, nCtlColor);

	// TODO:  Change any attributes of the DC here
	if (nCtlColor == CTLCOLOR_DLG || CTLCOLOR_MAX == nCtlColor)
	{
		hbr = m_brBkGround;
	}
	if (CTLCOLOR_STATIC == nCtlColor)
	{
		hbr = m_brBkGround;
		pDC->SetBkMode(TRANSPARENT);
	}

	return hbr;
}

BOOL CMainViewDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	SetDlgItemText(IDC_STATIC_DECODER_LIST, GetText(IDS_MAIN_DECODER_LIST));
	SetDlgItemText(IDC_STATIC_IP, GetText(IDS_MAIN_DECODER_IP));
	SetDlgItemText(IDC_STATIC_PORT, GetText(IDS_MAIN_PORT));
	SetDlgItemText(IDC_BUTTON_MANUAL_ADD, GetText(IDS_MAIN_MANUAL_ADD));
	SetDlgItemText(IDC_BUTTON_AUTO_SEARCH, GetText(IDS_MAIN_AUTO_SEARCH));
	SetDlgItemText(IDC_STATIC_POS, GetText(IDS_MAIN_SCREEN));
	SetDlgItemText(IDC_STATIC_VERSION_TITLE, GetText(IDS_MAIN_DECODER_VERSION));
	SetDlgItemText(IDC_BUTTON_ADD, GetText(IDS_MAIN_ADD));
	SetDlgItemText(IDC_BUTTON_ADVANCE_ADD, GetText(IDS_MAIN_ADVANCE_ADD));
	SetDlgItemText(IDC_BUTTON_MODIFY, GetText(IDS_MAIN_MODIFY));
	SetDlgItemText(IDC_BUTTON_DELETE, GetText(IDS_MAIN_DELETE));
	SetDlgItemText(IDC_BUTTON_AUTO_SWITCH, GetText(IDS_MAIN_AUTOSWITCH));
	SetDlgItemText(IDC_CHECK_LAST_FRAME, GetText(IDS_MAIN_LAST_FRAME));
	SetDlgItemText(IDC_BUTTON_PUSH_STREAM, GetText(IDS_MAIN_PUSH_STREAM));
	SetDlgItemText(IDC_BUTTON_CONNECT, GetText(IDS_MAIN_CONNECT));
	SetDlgItemText(IDC_BUTTON_DISCONNECT, GetText(IDS_MAIN_DISCONNECT));
	SetDlgItemText(IDC_BUTTON_AUDIO, GetText(IDS_MAIN_OPENAUDIO));
	SetDlgItemText(IDC_BUTTON_TALK, GetText(IDS_MAIN_STARTTALK));
	SetDlgItemText(IDC_BUTTON_CTRL, GetText(IDS_MAIN_DEVICE_CTRL));

	SetDlgItemText(IDC_CHECK_ENCRYPTKEY, GetText(IDS_MAINDLG_ENCRYPTKEY));
	SetDlgItemText(IDC_STATIC_ENCRYPT, GetText(IDS_MAINDLG_KET));

	SetDlgItemText(IDC_BUTTON_FASTPLAY, GetText(IDS_MAINDLG_FASTPLAY));
	SetDlgItemText(IDC_BUTTON_SLOWPLAY, GetText(IDS_MAINDLG_SLOWPLAY));

	SetDlgItemText(IDC_STC_LOCAL_PORT_ALARM, GetText(IDS_ALARM_LOCAL_PORT_ALARM));

	SetDlgItemText(IDC_STATIC_SYNC_LOOPTIME, GetText(IDS_MAIN_SYNC_LOOPTIME));
	SetDlgItemText(IDC_BUTTON_SYNC_LOOPCTRL, GetText(IDS_MAIN_SYNCSWITCH));
	SetDlgItemInt(IDC_EDIT_SYNC_LOOPTIME, 20);

	//m_brBkGround = CreateSolidBrush(RGB(2,153,0));		//
	m_brBkGround = CreateSolidBrush(RGB(0xF0, 0xFB, 0xFF));	//ԭNVD ҳɫһ

	m_edtEncryptKey.SetLimitText(16);
	

	if (CLS_NetAdmin_Interface::LoadDLL())
	{
		NetAdmin_Startup();
	}
	else
	{
		MessageBox(_T("error in load NetAdmin.dll"),_T(""),MB_TOPMOST|MB_OK);
	}

	if (CLS_NVDSDK_Interface::LoadDLL())
	{
		int iRet = 0;
		DEC_ClientStartup(0,NULL);
		DecNotifyFun tDecNotifyFun = {0};
		tDecNotifyFun.iSize = sizeof(DecNotifyFun);
		tDecNotifyFun.pMainNotify = MainNotify;
		tDecNotifyFun.pParamChangeNotify = ChangeParamNotify;
		DEC_ClientSetNotify(&tDecNotifyFun);
	}
	else
	{
		MessageBox(_T("error in load NVDSDK.dll"),_T(""),MB_TOPMOST|MB_OK);
	}

	m_cboSdkWorkMode.AddString("");
	m_cboSdkWorkMode.AddString("");
	m_cboSdkWorkMode.SetCurSel(0);

	m_lstImg.Create(16,16,ILC_COLOR32,3,3);
	m_lstImg.SetBkColor(RGB(255,255,255));
	HICON hIcon=AfxGetApp()->LoadIcon(IDI_OFFLINE);
	m_lstImg.Add(hIcon);
	hIcon=AfxGetApp()->LoadIcon(IDI_ONLINE);
	m_lstImg.Add(hIcon);
	m_tvDecoder.SetImageList(&m_lstImg,TVSIL_NORMAL);

	SetDlgItemInt(IDC_EDIT_PORT,3000);
#ifdef _DEBUG
	SetDlgItemText(IDC_EDIT_IP,_T("10.10.62.161"));
#endif

	m_lstNvs.SetExtendedStyle(m_lstNvs.GetExtendedStyle() | LVS_SHOWSELALWAYS);

	int iSubItem = 0;
	m_lstNvs.SetImageList(&m_lstImg,LVSIL_SMALL);
	m_lstNvs.SetExtendedStyle(LVS_EX_GRIDLINES|LVS_EX_FULLROWSELECT);
	m_lstNvs.InsertColumn(iSubItem++,GetText(IDS_MAIN_SERVER_IP),LVCFMT_LEFT,120);
	m_lstNvs.InsertColumn(iSubItem++,GetText(IDS_MAIN_CHANNEL),LVCFMT_LEFT,60);
	m_lstNvs.InsertColumn(iSubItem++,GetText(IDS_MAIN_STREAM),LVCFMT_LEFT,60);
	m_lstNvs.InsertColumn(iSubItem++,GetText(IDS_MAIN_NET_MODE),LVCFMT_LEFT,60);
	m_lstNvs.InsertColumn(iSubItem++,GetText(IDS_MAIN_HOLD_TIME),LVCFMT_LEFT,60);
	m_lstNvs.InsertColumn(iSubItem++,GetText(IDS_MAIN_PROXY_IP),LVCFMT_LEFT,80);						//5
	m_lstNvs.InsertColumn(iSubItem++,GetText(IDS_MAIN_PORT),LVCFMT_LEFT,60);
	m_lstNvs.InsertColumn(iSubItem++,GetText(IDS_MAIN_CONNECT_MODE),LVCFMT_LEFT,90);
	m_lstNvs.InsertColumn(iSubItem++,GetText(IDS_MAIN_USERNAME),LVCFMT_LEFT,80);
	m_lstNvs.InsertColumn(iSubItem++,GetText(IDS_MAIN_PASSWORD),LVCFMT_LEFT,80);	//һз******,().
	m_lstNvs.InsertColumn(iSubItem++,GetText(IDS_MAIN_DEVICE_TYPE),LVCFMT_LEFT,120);
	m_lstNvs.InsertColumn(iSubItem++,GetText(IDS_MAIN_DEVICE_ADDRESS),LVCFMT_LEFT,60);					//10
	m_lstNvs.InsertColumn(iSubItem++,GetText(IDS_MAIN_PASSWORD),LVCFMT_LEFT,0);		//
	m_lstNvs.InsertColumn(iSubItem++,GetText(IDS_ENCRYPT_PWD),LVCFMT_LEFT,80);
	m_lstNvs.InsertColumn(iSubItem++,GetText(IDS_DEV_PLAT_TYPE),LVCFMT_LEFT,60);
	m_lstNvs.InsertColumn(iSubItem++,GetText(IDS_ENCRYPT_PWD),LVCFMT_LEFT,0);		//ļ	//15
	m_lstNvs.InsertColumn(iSubItem++,GetText(IDS_MULT_IP),LVCFMT_LEFT,120);
	m_lstNvs.InsertColumn(iSubItem++,GetText(IDS_MULT_PORT),LVCFMT_LEFT,60);

	CFont* pFont = m_tvDecoder.GetFont();
	if (pFont)
	{
		LOGFONT lf = {0};
		pFont->GetLogFont(&lf);
		lf.lfHeight = 14;                      
		HFONT hFont = CreateFontIndirect(&lf);
		if (hFont)
		{
			pFont = CFont::FromHandle(hFont);
			m_tvDecoder.SetFont(pFont);
			m_lstNvs.SetFont(pFont);
		}
	}

	m_cboPos.AddString(_T("0"));
	m_cboPos.SetCurSel(0);
	m_cboPos.EnableWindow(TRUE);

	if (1 == m_iIsOCX)
	{
		GetDlgItem(IDC_BUTTON_PUSH_STREAM)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_CHECK_ENCRYPTKEY)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_STATIC_ENCRYPT)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_BUTTON_FASTPLAY)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_BUTTON_SLOWPLAY)->ShowWindow(SW_HIDE);
		GetDlgItem(IDC_EDIT_ENCRYPT)->ShowWindow(SW_HIDE);
	}
	else
	{
		//SetTimer(TIMER_PUSH_STREAM, 36, NULL);
		GetDlgItem(IDC_BUTTON_PUSH_STREAM)->ShowWindow(SW_NORMAL);
		GetDlgItem(IDC_CHECK_ENCRYPTKEY)->ShowWindow(SW_NORMAL);
		GetDlgItem(IDC_STATIC_ENCRYPT)->ShowWindow(SW_NORMAL);
		GetDlgItem(IDC_BUTTON_FASTPLAY)->ShowWindow(SW_NORMAL);
		GetDlgItem(IDC_BUTTON_SLOWPLAY)->ShowWindow(SW_NORMAL);
		GetDlgItem(IDC_EDIT_ENCRYPT)->ShowWindow(SW_NORMAL);
	}

	LoadDecoderList();

	ChangeAlarmState();

	m_cboSinglePic.AddString("ǵ");
	m_cboSinglePic.AddString("");
	m_cboSinglePic.SetCurSel(0);

	return TRUE; 
}
int CMainViewDlg::MainNotify( unsigned long _lID, unsigned int _uiMsg, unsigned int _iChannel, int _iPos, void* _pvParam, int _iParamSize, void* _pvUserData)
{
	_MAIN_NOTIFY_DATA* pData = (_MAIN_NOTIFY_DATA*)malloc(sizeof(_MAIN_NOTIFY_DATA));
	if (pData == NULL){
		return -1;
	}
	memset(pData, 0, sizeof(_MAIN_NOTIFY_DATA));
	pData->m_lID = _lID;
	pData->m_iMsg = _uiMsg;
	pData->m_iChannel = _iChannel;
	pData->m_iPos =_iPos;
	pData->m_pvUserData = _pvUserData;
	CMainViewDlg* pThis = (CMainViewDlg*)_pvUserData;
	if (_pvParam != NULL && _iParamSize > 0)
	{
		int iCopySize = min(_iParamSize, sizeof(MainNotifyParam));
		memcpy(&pData->tParam, _pvParam, iCopySize);
	}
	pThis->PostMessage(MSG_MAIN_NOTIFY,(LPARAM)pData,0);
	

	return 0;
}

int CMainViewDlg::ChangeParamNotify(unsigned long _lID, unsigned int _uiMsg, unsigned int _iChannel, int _iPos, void* _pvParam, int _iParamSize, void* _pvUserData)
{
	_CHANGE_PARAM_NOTIFY_DATA* pData = (_CHANGE_PARAM_NOTIFY_DATA*)malloc(sizeof(_CHANGE_PARAM_NOTIFY_DATA));
	if (pData == NULL){
		return -1;
	}
	memset(pData, 0, sizeof(_CHANGE_PARAM_NOTIFY_DATA));
	pData->m_lID = _lID;
	pData->m_iMsg = _uiMsg;
	pData->m_iChannel = _iChannel;
	pData->m_iPos =_iPos;
	pData->m_pvUserData = _pvUserData;
	CMainViewDlg* pThis = (CMainViewDlg*)_pvUserData;
	if (_pvParam != NULL && _iParamSize > 0)
	{
		int iCopySize = min(_iParamSize, sizeof(ChangeParamNotifyParam));
		memcpy(&(pData->tParam), _pvParam, iCopySize);
	}
	pThis->PostMessage(MSG_CHANGE_PARAM_NOTIFY,(LPARAM)pData,0);


	return 0;
}

LRESULT CMainViewDlg::OnMainNotify( WPARAM _WParam,LPARAM _LParam )
{
	_MAIN_NOTIFY_DATA* pData = (_MAIN_NOTIFY_DATA*)_WParam;
	if (pData == NULL)
	{
		AddLog(LOG_LEVEL_ERROR, "pData == NULL");
	}
	int iID = (int)pData->m_lID;
	int iType = pData->m_iMsg;
	switch(iType)
	{
	case DEC_WCM_DEC_LOGON:
		{
			
			int _iStatus = pData->tParam.iStatus;
			LogonNotify(iID,_iStatus);
			break;
		}
	case DEC_WCM_NVS_STARTVIEW:
		{
			int iChannel = pData->m_iChannel;
			int iPos = pData->m_iPos;
			StartViewNotify(iID,iChannel,iPos);
			break;
		}
	case DEC_WCM_NVS_STOPVIEW:
		{
			int iChannel = pData->m_iChannel;
			int iPos = pData->m_iPos;
			StopViewNotify(iID,iChannel,iPos);
			break;
		}
	case DEC_WCM_DEC_TALK:
		{
			int iChannel = pData->m_iChannel;
			int iPos = pData->m_iPos;
			TalkNotify(iID,iChannel,iPos,1);
			break;
		}
	case DEC_WCM_ERR_ORDER:
		{
			ErrorOrderNotify(iID);
			break;
		}
	case DEC_WCM_DEC_PARASET:
		{
			ParamChangeNotify(iID);
			break;
		}
	case DEC_WCM_DEC_AUDIOSTATUS:
	case DEC_WCM_DEC_AUDIO_FAILED:
		{
			int iChannel = pData->m_iChannel;
			int iPos = pData->m_iPos;
			AddLog(LOG_LEVEL_DEBUG,"[DEC_WCM_DEC_AUDIO%s] ID(%d),Channel(%d),Pos(%d)"
				,DEC_WCM_DEC_AUDIOSTATUS == iType ? "STATUS" : "_FAILED",iID,iChannel,iPos);
			AudioNotify(iID,iChannel,iPos);
			break;
		}
	case DEC_WCM_DEC_TALK_FAILED:
		{
			int iChannel = pData->m_iChannel;
			int iPos = pData->m_iPos;
			TalkNotify(iID,iChannel,iPos,0);
			break;
		}
	case DEC_WCM_DEC_PUSHSTREAM:
		{
			int iResult = pData->tParam.tPushStreamResponse.result;
			int iPushId = pData->tParam.tPushStreamResponse.lPushId;
			int iStart = 0;
			AddLog(LOG_LEVEL_DEBUG,"[DEC_WCM_DEC_PUSHSTREAM] PushID(%d),Result(%d)",iPushId,iResult);
			if (ERR_SUCCESS == iResult)
			{
				iStart = 1;
			}
			PushStreamNotify(iID, iPushId,iStart);
			break;
		}
	case DEC_WCM_ERR_PUSHSTREAM:
		{
			AddLog(LOG_LEVEL_DEBUG,"[DEC_WCM_ERR_PUSHSTREAM] PushID(%d)",iID);
			PushStreamNotify(iID,pData->tParam.iPushId,0); 
			
			break;
		}
	case DEC_WCM_ERR_USERPASS:
		{
			int iResult = pData->tParam.iUserPassResult;
			ChangePassNotify(iID,iResult);
			break;
		}
	case DEC_WCM_DEC_UPGRADE: 
	case DEC_WCM_DEC_UPGRADELOGO:
	case DEC_WCM_DEC_UPGRADEP:
	case DEC_WCM_DEC_UPGRADEWEB:
	case DEC_WCM_DEC_UPGRADEPROCESS:
	case DEC_WCM_QUERY_LOG_FINISH:
	case DEC_WCM_SEARCH_IPC:
	case DEC_WCM_SEARCH_NVD:
	case DEC_WCM_EXPORT_CONFIG_FINISH:
	case DEC_WCM_LOG_WRITE:
	case DEC_WCM_DEC_SCREENCTLSET:
	case DEC_WCM_DEC_REBOOTTRADE:
	case DEC_WCM_DEC_GETUDISK_VIDEOLISTS:
		{
			if (m_pDlgSetting)
			{
				m_pDlgSetting->UpdateNotify(pData);
			}
			break;
		}
	case DEC_WCM_ALARM_NOTIFY:
		{
			ChangeAlarmNotify(iID);
			break;
		}
	case DEC_WCM_DETECT_CHANN_STATE:
		{
			UpdataChannelState(iID);
			break;
		}
	case DEC_WCM_PARASET_CREATEVVO:
		{
			CreatevvoNotify(iID);
			break;
		}
	case DEC_WCM_DEC_LAST_ERROR:
		{
			AddLog(LOG_LEVEL_DEBUG,"[DEC_WCM_DEC_LAST_ERROR]");
			break;
		}
	case DEC_WCM_DEC_PICSNAP:
	case DEC_WCM_DEC_GETPICFILENAME:
		{
			PicsnapNotify(pData);
			break;
		}
	default:
		if (m_pDlgSetting)
		{
			m_pDlgSetting->UpdateNotify(pData);
		}
		break;
	}
	free(pData);
	return S_OK;
}

LRESULT CMainViewDlg::OnChangeParamNotify( WPARAM _WParam,LPARAM _LParam )
{
	_CHANGE_PARAM_NOTIFY_DATA* pData = (_CHANGE_PARAM_NOTIFY_DATA*)_WParam;
	if(pData == NULL)
	{
		AddLog(LOG_LEVEL_DEBUG,"LRESULT CMainViewDlg::OnChangeParamNotify param error");
		return -1;
	}
	if (m_pDlgSetting)
	{
		m_pDlgSetting->ChangeParamNotify(pData);
	}

	if (DEC_PARACHANGE_SINGLE_PIC == pData->m_iMsg)
	{
		UpdateSinglePicture();
	}
	else if (DEC_PARACHANGE_APPLY_PLAN == pData->m_iMsg)
	{
		CreatevvoNotify(pData->m_lID);
	}

	if(pData != NULL)
	{
		free(pData);
	}
	return 0;
}

int CMainViewDlg::LogonNotify( int _iID,int _iState )
{
	HTREEITEM hItem = FindItem(_iID);
	if (hItem == NULL)
	{
		return 0;
	}

	DeleteAllChild(hItem);
	switch(_iState)
	{
	case DEC_LOGON_SUCCESS:
		{
			
			UpdateDECVersion(_iID);
			AddLog(LOG_LEVEL_DEBUG,"[CMainViewDlg::LogonNotify][DEC_LOGON_SUCCESS] ID(%d)",_iID);
			m_tvDecoder.SetItemImage(hItem,STATE_ONLINE,STATE_ONLINE);
			CreatevvoNotify(_iID);
			break;
		}
	default:
		{
			AddLog(LOG_LEVEL_DEBUG,"[CMainViewDlg::LogonNotify]State(%d),ID(%d)",_iState,_iID);
			m_tvDecoder.SetItemData(hItem,(DWORD_PTR)-1);
			m_tvDecoder.SetItemImage(hItem,STATE_OFFLINE,STATE_OFFLINE);
			st_Decoder* pDecoder = GetDecoder(_iID);
			if (NULL ==  pDecoder)
			{
				abort(); // not happen
			}
			pDecoder->m_lID = -1;
			DEC_ClientLogout(_iID);
			
			Logon(hItem,TRUE);
			break;
		}
	}

	return 0;
}

int CMainViewDlg::StartViewNotify( int _iID,int _iChannel,int _iPos)
{
	AddLog(LOG_LEVEL_DEBUG,"[DEC_WCM_NVS_STARTVIEW] ID(%d),Channel(%d),Pos(%d)"
		,_iID,_iChannel,_iPos);

	UpdateNVSItemStatus(_iID,_iChannel,_iPos);

	return 0;
}

int CMainViewDlg::StopViewNotify( int _iID,int _iChannel,int _iPos)
{
	AddLog(LOG_LEVEL_INFO,"[DEC_WCM_NVS_STOPVIEW] ID(%d),Channel(%d),Pos(%d)"
		,_iID,_iChannel,_iPos);

	if(UpdateNVSItemStatus(_iID,_iChannel,_iPos) == 0)
	{
		AddLog(LOG_LEVEL_DEBUG,"[DEC_WCM_NVS_STOPVIEW] ID(%d),Channel(%d),Pos(%d)"
			,_iID,_iChannel,_iPos);
		if(m_tNextItem.m_iDecID == _iID && m_tNextItem.m_iChan == _iChannel && m_tNextItem.m_iPic == _iPos)
		{
			ServerItem tServerItem = {0};
			//int iType = m_tNextItem.m_viewItem.m_iDevPlatType;//TODO
			//ConvertItem(tServerItem, &m_tNextItem.m_viewItem);
			int iType = DEVTYPE_NORMAL;
			ConvertSeverToItem(&m_tNextItem.m_tViewServer, &tServerItem, &iType);
			tServerItem.tNormal.tCommonInfo.iSaveCfg = !m_chk_SaveCfg.GetCheck();
			int iRet = DEC_ClientStartView_V1(_iID, _iChannel, _iPos, iType, &tServerItem);
			memset(&m_tNextItem, -1, sizeof(m_tNextItem));
			if (iRet < 0)
			{
				AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::StopViewNotify] Start View Failed! Ret(%d),Error(0x%08x),ID(%d),Channel(%d),Pos(%d)"
					,iRet,GetLastError(),_iID,_iChannel,_iPos);
			}
		}
	}

	return -1;
}

int CMainViewDlg::TalkNotify( int _iID,int _iChannel,int _iPos,int _iStatus )
{
	AddLog(LOG_LEVEL_DEBUG,"[DEC_WCM_DEC_TALK%s] ID(%d),Channel(%d),Pos(%d)"
		,_iStatus == 0 ? "_FAILED" : "",_iID,_iChannel,_iPos);

	return UpdateTalkStatus(GetCurrentID(),GetCurrentChannel(),GetCurrentPos());
}

int CMainViewDlg::ErrorOrderNotify( int _iID )
{
	AddLog(LOG_LEVEL_WARN,"[DEC_WCM_ERR_ORDER] Error Order!ID(%d)",_iID);

	HTREEITEM hItem = FindItem(_iID);
	if (hItem == NULL)
	{
		return 0;
	}
	
	Logoff(hItem);
	return 0;
}

int CMainViewDlg::ParamChangeNotify( int _iID )
{
	int iID = GetCurrentID();
	if (_iID == iID)
	{
		int iChannel = GetCurrentChannel();
		int iPos = m_cboPos.GetCurSel();
		UpdateChannelInfo(iID, iChannel, iPos);
	}

	return 0;
}

int CMainViewDlg::AudioNotify( int _iID,int _iChannel,int _iPos)
{
	return UpdateAudioStatus(GetCurrentID(),GetCurrentChannel(),GetCurrentPos());
}

int CMainViewDlg::ChangePassNotify( int _iID,int _iResult )
{
	AddLog(LOG_LEVEL_DEBUG, "[CMainViewDlg::ChangePassNotify]Change password, result(%d)", _iResult);
	if (0 == _iResult)
	{
		MessageBox(GetText(IDS_MSG_CHGPWD_OK), GetText(IDS_CHGPWD_CHANGE), MB_OK|MB_TOPMOST);
	}
	else
	{
		MessageBox(GetText(IDS_MSG_CHGPWD_FAILED), GetText(IDS_CHGPWD_CHANGE), MB_OK|MB_TOPMOST);
	}

	return 0;
}

HTREEITEM CMainViewDlg::FindItem( CString _strItem)
{
	HTREEITEM hItem = m_tvDecoder.GetChildItem(TVI_ROOT);
	CString strItem;
	while(hItem)
	{
		strItem = m_tvDecoder.GetItemText(hItem);
		if(_strItem.CompareNoCase(strItem) == 0)
		{
			return hItem;
		}
		hItem=m_tvDecoder.GetNextSiblingItem(hItem);
	}
	return NULL;
}

HTREEITEM CMainViewDlg::FindItem( int _iID )
{
	HTREEITEM hItem = m_tvDecoder.GetChildItem(TVI_ROOT);
	int iLogonID;
	while(hItem)
	{
		iLogonID = (int)m_tvDecoder.GetItemData(hItem);
		if(iLogonID == _iID)
		{
			return hItem;
		}
		hItem=m_tvDecoder.GetNextSiblingItem(hItem);
	}
	return NULL;
}

int CMainViewDlg::GetCurrentID()
{
	int iID = -1;
	HTREEITEM hItem = m_tvDecoder.GetSelectedItem();
	if (hItem)
	{
		HTREEITEM hParentItem = m_tvDecoder.GetParentItem(hItem);
		if (hParentItem)
		{
			iID = (int)m_tvDecoder.GetItemData(hParentItem);
		}
		else
		{
			iID = (int)m_tvDecoder.GetItemData(hItem);
		}
	}

	return iID;
}

int CMainViewDlg::GetCurrentChannel()
{
	int iChannel = m_iLastChannel;
	HTREEITEM hItem = m_tvDecoder.GetSelectedItem();
	if (hItem)
	{
		HTREEITEM hParentItem = m_tvDecoder.GetParentItem(hItem);
		if (hParentItem)
		{
			iChannel = (int)m_tvDecoder.GetItemData(hItem);
		}
	}

	return iChannel;
}

int CMainViewDlg::GetCurrentPos()
{
	return GetComboData(&m_cboPos);
}

st_Decoder* CMainViewDlg::GetDecoder( char* _cIP )
{
	for (unsigned int i = 0; i < m_VecDecoder.size(); ++i)
	{
		st_Decoder* pDecoder = (st_Decoder*)m_VecDecoder[i];
		if (NULL == pDecoder)
		{
			AddLog(LOG_LEVEL_DEBUG,"NULL ==  pDecoder");
			continue;
		}

		if(strcmp(pDecoder->m_cIP,_cIP) == 0)
		{
			return pDecoder;
		}
	}

	return NULL;
}

st_Decoder* CMainViewDlg::GetDecoder( int _iID )
{
	for (unsigned int i = 0; i < m_VecDecoder.size(); ++i)
	{
		st_Decoder* pDecoder = (st_Decoder*)m_VecDecoder[i];
		if (NULL ==  pDecoder)
		{
			AddLog(LOG_LEVEL_DEBUG,"NULL ==  pDecoder");
			continue;
		}

		if(pDecoder->m_lID == _iID)
		{
			return pDecoder;
		}
	}

	return NULL;
}

st_Decoder* CMainViewDlg::GetCurrentDecoder()
{
	HTREEITEM hItem = m_tvDecoder.GetSelectedItem();
	if (hItem)
	{
		HTREEITEM hParentItem = m_tvDecoder.GetParentItem(hItem);
		if (hParentItem)
		{
			hItem = hParentItem;
		}
		CString strIP = m_tvDecoder.GetItemText(hItem);
		return GetDecoder((LPSTR)(LPCTSTR)strIP);
	}

	return NULL;
}

int CMainViewDlg::AddDecoder(st_Decoder* _pDecoder)
{
	if (NULL == _pDecoder)
	{
		AddLog(LOG_LEVEL_DEBUG,"_pDecoder == NULL");
		return -1;
	}

	bool blFind = false;
	for(unsigned int i=0;i<m_VecDecoder.size();++i)
	{
		st_Decoder* pDecoder = (st_Decoder*)m_VecDecoder[i];
		if (NULL ==  pDecoder)
		{
			AddLog(LOG_LEVEL_DEBUG,"NULL ==  pDecoder");
			continue;
		}

		if(strcmp(pDecoder->m_cIP,_pDecoder->m_cIP) == 0)
		{
			pDecoder->m_iPort = _pDecoder->m_iPort;
			blFind = true;
			break;
		}
	}

	if(false == blFind)
	{
		int iDecNumber = m_tvDecoder.GetCount();
		if (iDecNumber >= MAX_DECPDER_NUM)
		{
			CString strMsg;
			strMsg.Format(_T("%s%d%s"),GetText(IDS_MAIN_MAX_DECODER_NUM_BEGIN),MAX_DECPDER_NUM,GetText(IDS_MAIN_MAX_DECODER_NUM_END));
			MessageBox(strMsg,_T(""),MB_OK|MB_TOPMOST);
			goto END;
		}

		HTREEITEM hItem = m_tvDecoder.InsertItem((LPCTSTR)_pDecoder->m_cIP);
		if (hItem)
		{
			m_tvDecoder.SetItemData(hItem,DWORD_PTR(-1));
			m_tvDecoder.SetItemImage(hItem,STATE_OFFLINE,STATE_OFFLINE);
			st_Decoder* pDecoder = new st_Decoder;
			*pDecoder = *_pDecoder;
			m_VecDecoder.push_back(pDecoder);
		}
	}

END:
	return 0;
}

void CMainViewDlg::OnBnClickedButtonManualAdd()
{
	CString strIP;
	GetDlgItemText(IDC_EDIT_IP,strIP);
	int iPort = GetDlgItemInt(IDC_EDIT_PORT);
	if(IsValidIP((LPSTR)(LPCTSTR)strIP) != 1)
	{
		MessageBox(GetText(IDS_MAIN_INVALID_IP),_T(""),MB_OK|MB_TOPMOST);
		return;
	}
	if(iPort < MIN_SERVER_PORT || iPort > MAX_SERVER_PORT)
	{
		MessageBox(GetText(IDS_MAIN_INVALID_PORT),_T(""),MB_OK|MB_TOPMOST);
		return;
	}

	//give message if the device has exist
	for(unsigned int i=0;i<m_VecDecoder.size();++i)
	{
		st_Decoder* pDecoder = (st_Decoder*)m_VecDecoder[i];
		if (NULL ==  pDecoder)
		{
			AddLog(LOG_LEVEL_DEBUG,"NULL ==  pDecoder");
			continue;
		}

		if(strcmp(pDecoder->m_cIP, strIP) == 0)
		{
			MessageBox(GetText(IDS_DECODER_EXIST),_T(""),MB_OK|MB_TOPMOST);
			return;
		}
	}

	st_Decoder sDecoder;
	strcpy_s(sDecoder.m_cIP,sizeof(sDecoder.m_cIP),(LPSTR)(LPCTSTR)strIP);
	sDecoder.m_iPort = iPort;
	AddDecoder(&sDecoder);
	SaveDecoderList();
}

void CMainViewDlg::OnBnClickedButtonAutoSearch()
{
	NetAdmin_SetNotify(&CMainViewDlg::FindServer);
	NetAdmin_SeekServers();
}

void CMainViewDlg::FindServer( PTDEVICE _pDevice )
{
	if (_pDevice->m_iDeviceType != 9)
		return;

	if (s_pSelf)
	{	
		st_Decoder* pDecoder = new st_Decoder();
		if (NULL ==  pDecoder)
		{
			return;
		}
		strcpy_s(pDecoder->m_cIP,sizeof(pDecoder->m_cIP), _pDevice->m_cIP);
		pDecoder->m_iPort = _pDevice->m_iServerPort;


		s_pSelf->PostMessage(MSG_FIND_DEVICE, (LPARAM)pDecoder, NULL);
	}
}

void CMainViewDlg::OnNMRClickTreeDecoder(NMHDR* /*pNMHDR*/, LRESULT* /*pResult*/)
{
	HTREEITEM hItem = NULL;
	POINT pointCursor = {0};	

	GetCursorPos(&pointCursor);	
	m_tvDecoder.ScreenToClient(&pointCursor);
	hItem = m_tvDecoder.HitTest(pointCursor);
	m_tvDecoder.SelectItem(hItem);	
	if (hItem == NULL)
	{
		return;
	}

	CMenu menu;
	menu.CreatePopupMenu();
	HTREEITEM hParentItem = m_tvDecoder.GetParentItem(hItem);
	if(hParentItem == NULL)
	{	
		menu.AppendMenu(MF_STRING, ID_LOGON,GetText(IDS_MENU_DECODER_LOGON));
		menu.AppendMenu(MF_STRING, ID_LOGOFF,GetText(IDS_MENU_DECODER_LOGOFF));
		menu.AppendMenu(MF_SEPARATOR);
		menu.AppendMenu(MF_STRING, ID_SET,GetText(IDS_MENU_DECODER_SET));
		menu.AppendMenu(MF_STRING, ID_PASSWORD,GetText(IDS_MENU_DECODER_PASSWORD));
		menu.AppendMenu(MF_STRING, ID_REBOOT,GetText(IDS_MENU_DECODER_REBOOT));
		menu.AppendMenu(MF_SEPARATOR);
		menu.AppendMenu(MF_STRING, ID_DELETE,GetText(IDS_MENU_DECODER_DELETE));

		int iImage = -1;
		m_tvDecoder.GetItemImage(hItem,iImage,iImage);
		if(STATE_ONLINE == iImage)
		{
			menu.EnableMenuItem(ID_LOGON,MF_GRAYED);
			menu.EnableMenuItem(ID_DELETE,MF_GRAYED);
		}
		else if (STATE_OFFLINE == iImage)
		{
			menu.EnableMenuItem(ID_LOGOFF,MF_GRAYED);
			menu.EnableMenuItem(ID_SET,MF_GRAYED);
			menu.EnableMenuItem(ID_PASSWORD,MF_GRAYED);
			menu.EnableMenuItem(ID_REBOOT,MF_GRAYED);
		}
	}
	else
	{
		int iID= (int) m_tvDecoder.GetItemData(hParentItem);
		TDECPARAM tDecParam = {0};
		int iRet = DEC_ClientGetDecoderPara(iID,&tDecParam);//---------------->>ȡ 


		if(ERR_SUCCESS == iRet)
		{
			int iChannel = (int)m_tvDecoder.GetItemData(hItem);
// 			if(iChannel<0 || iChannel>=(DEC_MAX_CHANNEL_TOTAL_NUM))
// 			{
// 				return;
// 			}

			//ȥ3
			menu.AppendMenu(MF_STRING, ID_SCREEN_1, GetText(IDS_MENU_SCREEN_1));
			menu.AppendMenu(MF_STRING, ID_SCREEN_2, GetText(IDS_MENU_SCREEN_2));
			menu.AppendMenu(MF_STRING, ID_SCREEN_3, GetText(IDS_MENU_SCREEN_3));
			menu.AppendMenu(MF_STRING, ID_SCREEN_4, GetText(IDS_MENU_SCREEN_4));
			menu.AppendMenu(MF_STRING, ID_SCREEN_6, GetText(IDS_MENU_SCREEN_6));
			menu.AppendMenu(MF_STRING, ID_SCREEN_8, GetText(IDS_MENU_SCREEN_8));
			menu.AppendMenu(MF_STRING, ID_SCREEN_9, GetText(IDS_MENU_SCREEN_9));
			menu.AppendMenu(MF_STRING, ID_SCREEN_10, GetText(IDS_MENU_SCREEN_10));
			menu.AppendMenu(MF_STRING, ID_SCREEN_13, GetText(IDS_MENU_SCREEN_13));
			menu.AppendMenu(MF_STRING, ID_SCREEN_16, GetText(IDS_MENU_SCREEN_16));
			menu.AppendMenu(MF_STRING, ID_SCREEN_20A, GetText(IDS_MENU_SCREEN_20A));
			menu.AppendMenu(MF_STRING, ID_SCREEN_20B, GetText(IDS_MENU_SCREEN_20B));
			menu.AppendMenu(MF_STRING, ID_SCREEN_25, GetText(IDS_MENU_SCREEN_25));
			menu.AppendMenu(MF_STRING, ID_SCREEN_36, GetText(IDS_MENU_SCREEN_36));
			menu.AppendMenu(MF_STRING, ID_SCREEN_40, GetText(IDS_MENU_SCREEN_40));
			menu.AppendMenu(MF_STRING, ID_SCREEN_64, GetText(IDS_MENU_SCREEN_64));
			menu.AppendMenu(MF_STRING, ID_SCREEN_81, GetText(IDS_MENU_SCREEN_81));
			menu.AppendMenu(MF_STRING, ID_SCREEN_100, GetText(IDS_MENU_SCREEN_100));
			menu.AppendMenu(MF_STRING, ID_SCREEN_0, GetText(IDS_MENU_SCREEN_0));
		
			
			
			ChannelPicNum tPicNum = {0};
			tPicNum.iSize = sizeof(ChannelPicNum);

			int iID = GetCurrentID();
			int iRet = DEC_ClientGetDevConfig(iID, iChannel, 0, CMD_DEC_CFG_PICNUM, &tPicNum, sizeof(ChannelPicNum));
			if (ERR_SUCCESS != iRet)
			{
				AddLog(LOG_LEVEL_WARN,"[CMainViewDlg::LogonNotify] DEC_ClientGetDevConfig failed!Ret(%d),Error(0x%08x),ID(%d)"
					, iRet, GetLastError(), iID);
				return;
			}

			int iPic = tPicNum.iPicNum;
// 			if (iChannel < DEC_MAX_PHYSICAL_CHANNEL_NUM)
// 			{
// 				iPic = stChnNumAndMode.iLocalChnMode[iChannel];
// 			} 
// 			else
// 			{
// 				iPic = stChnNumAndMode.iVOChnMode[iChannel-DEC_MAX_CHANNEL_NUM_NEW];
// 			}

			
			switch(iPic)
			{
			case 1://
				{
					menu.EnableMenuItem(ID_SCREEN_1,MF_GRAYED);
					break;
				}
			case 2://2
				{
					menu.EnableMenuItem(ID_SCREEN_2,MF_GRAYED);
					break;
				}
			case 4://4
				{
					menu.EnableMenuItem(ID_SCREEN_4,MF_GRAYED);
					break;
				}
			case 0://0
				{
					menu.EnableMenuItem(ID_SCREEN_0,MF_GRAYED);
					break;
				}
			case 3:
				{
					menu.EnableMenuItem(ID_SCREEN_3, MF_GRAYED);
					break;
				}
			case 6:
				{
					menu.EnableMenuItem(ID_SCREEN_6, MF_GRAYED);
					break;
				}
			case 8:
				{
					menu.EnableMenuItem(ID_SCREEN_8, MF_GRAYED);
					break;
				}
			case 9:
				{
					menu.EnableMenuItem(ID_SCREEN_9, MF_GRAYED);
					break;
				}
			case 16:
				{
					menu.EnableMenuItem(ID_SCREEN_16, MF_GRAYED);
					break;
				}
			case 10:
				{
					menu.EnableMenuItem(ID_SCREEN_10, MF_GRAYED);
					break;
				}
			case 13:
				{
					menu.EnableMenuItem(ID_SCREEN_13, MF_GRAYED);
					break;
				}
			case 20:
				{
					if (tPicNum.iMode == 0)
					{
						menu.EnableMenuItem(ID_SCREEN_20A, MF_GRAYED);
					}
					else
					{
						menu.EnableMenuItem(ID_SCREEN_20B, MF_GRAYED);
					}
					
					
					break;
				}
			case 21:
				{
					
					break;
				}
			case 25:
				{
					menu.EnableMenuItem(ID_SCREEN_25, MF_GRAYED);
					break;
				}
			case 36:
				{
					menu.EnableMenuItem(ID_SCREEN_36, MF_GRAYED);
					break;
				}
			case 40:
				{
					menu.EnableMenuItem(ID_SCREEN_40, MF_GRAYED);
					break;
				}
			case 64:
				{
					menu.EnableMenuItem(ID_SCREEN_64, MF_GRAYED);
					break;
				}
			case 81:
				{
					menu.EnableMenuItem(ID_SCREEN_81, MF_GRAYED);
					break;
				}
			case 100:
				{
					menu.EnableMenuItem(ID_SCREEN_100, MF_GRAYED);
					break;
				}
			}
			//Ͻ20
			char cCap[64] = {0};
			iRet = DEC_ClientGetCapability(iID,cCap);
			if (ERR_SUCCESS == iRet)
			{
				int iCapability = atoi(cCap);
				if(iCapability < CAP_6)
				{
					menu.RemoveMenu(ID_SCREEN_0,MF_BYCOMMAND);
					menu.RemoveMenu(ID_SCREEN_2,MF_BYCOMMAND);
				}
				// ʱעΪ3716C׼޸ĽΪ7 [4/12/2012 hanyongqiang]
				/*
				else if (iCapability == CAP_6)
				{
					menu.RemoveMenu(ID_SCREEN_6,MF_BYCOMMAND);
					menu.RemoveMenu(ID_SCREEN_8,MF_BYCOMMAND);
					menu.RemoveMenu(ID_SCREEN_9,MF_BYCOMMAND);
				}*/
			}
			else
			{
				AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::OnNMRClickTreeDecoder]Get Capability Failed!Ret(%d),Error(0x%08x),ID(%d)"
					,iRet,GetLastError(),iID);
			}
		}
		else
		{
			AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::OnNMRClickTreeDecoder]Get Decoder Para Failed!Ret(%d),Error(0x%08x),ID(%d)"
				,iRet,GetLastError(),iID);
			return;
		}    
	}

	m_tvDecoder.ClientToScreen(&pointCursor);
	menu.TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,pointCursor.x,pointCursor.y,this);
	menu.DestroyMenu();
}

void CMainViewDlg::OnLogon()
{
	HTREEITEM hItem = m_tvDecoder.GetSelectedItem();
	Logon(hItem);
}

void CMainViewDlg::OnLogoff()
{
	HTREEITEM hItem = m_tvDecoder.GetSelectedItem();
	Logoff(hItem);
}

void CMainViewDlg::OnSet()
{
	CSettingDialog dlgSetting;
	m_pDlgSetting = &dlgSetting;
	HTREEITEM hItem = m_tvDecoder.GetSelectedItem();
	LONG lLogonID = (LONG)m_tvDecoder.GetItemData(hItem);
	if(lLogonID != m_iLastID)	lLogonID = m_iLastID;
	dlgSetting.Initialize(lLogonID);
	dlgSetting.DoModal();
	m_pDlgSetting = NULL;
}

void CMainViewDlg::OnPassword()
{
	HTREEITEM hItem = m_tvDecoder.GetSelectedItem();
	LONG lLogonID = (LONG)m_tvDecoder.GetItemData(hItem);

	CPWDChangeDlg dlgChangePWD(lLogonID, this);
	dlgChangePWD.DoModal();
}

void CMainViewDlg::OnReboot()
{
	HTREEITEM hItem = m_tvDecoder.GetSelectedItem();
	LONG lLogonID = (LONG)m_tvDecoder.GetItemData(hItem);
	if (hItem == NULL)
	{
		return;
	}
	HTREEITEM hParentItem = m_tvDecoder.GetParentItem(hItem);
	if(hParentItem == NULL)
	{	
		int iImage = -1;
		m_tvDecoder.GetItemImage(hItem,iImage,iImage);
		if(STATE_ONLINE == iImage)
		{
			if (DEC_ClientRebootDecoder(lLogonID) == 0)
			{
				AddLog(LOG_LEVEL_WARN, "[User] Reboot decoder successfully!");
			}
		}
	}
}

void CMainViewDlg::OnDelete()
{
	HTREEITEM hItem = m_tvDecoder.GetSelectedItem();
	DeleteDecoder(hItem);
	SaveDecoderList();
}

int CMainViewDlg::Logon( HTREEITEM _hItem ,BOOL _bShow)
{
	CString strDecIP = m_tvDecoder.GetItemText(_hItem);
	for(unsigned int i=0;i<m_VecDecoder.size();++i)
	{
		st_Decoder* pDecoder = (st_Decoder*)m_VecDecoder[i];
		if (NULL ==  pDecoder)
		{
			AddLog(LOG_LEVEL_DEBUG,"NULL ==  pDecoder");
			continue;
		}

		if(strDecIP.CompareNoCase(pDecoder->m_cIP) == 0)
		{
			if(_bShow == TRUE || pDecoder->m_bStayPass == false)
			{
				CLogon dlgLogon;
				dlgLogon.Init(pDecoder);
				if(dlgLogon.DoModal() != IDOK)
				{
					return 0;
				}
			}

			int iRet = DEC_ClientLogonEx(pDecoder->m_cIP
				,(char*)(LPCTSTR)pDecoder->m_astrUser
				,(char*)(LPCTSTR)pDecoder->m_astrPass
				,pDecoder->m_iPort, this);
			if (iRet >= 0)
			{
				pDecoder->m_lID = iRet;
				m_tvDecoder.SetItemData(_hItem,(DWORD_PTR)iRet);
			}
			else	
			{
				AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::Logon] Logon failed! Ret(%d),Error(0x%08x),IP(%s),User(%s),Pwd(%s),Port(%d)"
					,iRet,GetLastError(),pDecoder->m_cIP,pDecoder->m_astrUser,
					pDecoder->m_astrPass,pDecoder->m_iPort);
			}
			break;
		}
	}

	return 0;
}

int CMainViewDlg::Logoff( HTREEITEM _hItem )
{
	int iShowLastPic = m_chkLastFrame.GetCheck();
	st_Decoder* ptDecoder = GetCurrentDecoder();
	if (ptDecoder == NULL)
	{
		return -1;
	}
	
	for (int i=0; i<DEC_MAX_PORT_NUM; i++)
	{
		m_iPortAlarm[i] = false;
	}
	ChangeAlarmState();


	for(int j=0; j<(DEC_MAX_CHANNEL_TOTAL_NUM); ++j)
	{
		for(int k=0; k<DEC_MAX_WINDOW_TOTAL_NUM; ++k)
		{
			st_PushStream& tPush = ptDecoder->m_stPush[j][k];
			if(tPush.m_bStart)
			{
				InnerStopPush(&tPush);
				GetDlgItem(IDC_BUTTON_FASTPLAY)->SetWindowText(GetText(IDS_MAINDLG_FASTPLAY));
				GetDlgItem(IDC_BUTTON_SLOWPLAY)->SetWindowText(GetText(IDS_MAINDLG_SLOWPLAY));
				CString strTemp;
				GetDlgItemText(IDC_BUTTON_AUDIO,strTemp);
				if (strTemp == GetText(IDS_MAIN_CLOSEAUDIO))
				{
					SetDlgItemText(IDC_BUTTON_AUDIO, GetText(IDS_MAIN_OPENAUDIO));
				}
			}
			tPush.m_lPushID = -1;
		}
	}
	
	Sleep(500);//ȴStopPushЭȫȥ

	int iID = (int)m_tvDecoder.GetItemData(_hItem);
	ptDecoder->m_lID = -1;
	int iRet = DEC_ClientLogout(iID);
	if (ERR_SUCCESS == iRet)
	{
		AddLog(LOG_LEVEL_DEBUG,"[CMainViewDlg::Logoff] Logout success!ID(%d)",iID);
	}  
	else
	{
		AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::Logoff] Logout failed!Ret(%d),Error(0x%08x),ID(%d)"
			,iRet,GetLastError(),iID);
	}

	DeleteAllChild(_hItem);
	m_tvDecoder.SetItemData(_hItem,(DWORD_PTR)-1);
	m_tvDecoder.SetItemImage(_hItem,STATE_OFFLINE,STATE_OFFLINE);
	UpdateChannelInfo(-1,0,0);

	return 0;
}

int CMainViewDlg::DeleteAllChild( HTREEITEM _hItem)
{
	if (_hItem == NULL)
	{
		return 0;
	}

	HTREEITEM hItem = m_tvDecoder.GetChildItem(_hItem);
	while(hItem)
	{
		m_tvDecoder.DeleteItem(hItem);
		hItem = m_tvDecoder.GetChildItem(_hItem);
	}

	return 0;
}

int CMainViewDlg::DeleteDecoder( HTREEITEM _hItem )
{
	if (_hItem == NULL)
	{
		return 0;
	}

	CString strIP = m_tvDecoder.GetItemText(_hItem);
	vector<st_Decoder* >::iterator it = m_VecDecoder.begin();
	for (; it != m_VecDecoder.end(); ++it)
	{
		st_Decoder* pDecoder = (st_Decoder*)*it;
		if (NULL ==  pDecoder)
		{
			AddLog(LOG_LEVEL_DEBUG,"NULL ==  pDecoder");
			continue;
		}

		if(strIP.Compare(CString(pDecoder->m_cIP)) == 0)
		{
			m_VecDecoder.erase(it);
			delete pDecoder;
			break;
		}
	}
	m_tvDecoder.DeleteItem(_hItem);
	DeleteAllChild(_hItem);


	return 0;
}

void CMainViewDlg::OnNMDblclkTreeDecoder(NMHDR* /*pNMHDR*/, LRESULT* /*pResult*/)
{
	HTREEITEM hItem = m_tvDecoder.GetSelectedItem();
	if (m_tvDecoder.GetParentItem(hItem) == NULL)
	{
		int iImage = -1;
		m_tvDecoder.GetItemImage(hItem,iImage,iImage);
		if (STATE_OFFLINE == iImage)
		{
			Logon(hItem);
		}
	}
}

void CMainViewDlg::OnTvnSelchangedTreeDecoder(NMHDR *pNMHDR, LRESULT* /*pResult*/)
{
	LPNMTREEVIEW pNMTreeView = reinterpret_cast<LPNMTREEVIEW>(pNMHDR);

	HTREEITEM hItem = pNMTreeView->itemNew.hItem;
	if (hItem == NULL)
	{
		return;
	}

	int iID = -1;
	int iChannel = 0;
	HTREEITEM hParentItem = m_tvDecoder.GetParentItem(hItem);
	if (hParentItem)
	{
		iID = (int)m_tvDecoder.GetItemData(hParentItem);
		iChannel = (int)m_tvDecoder.GetItemData(hItem);
	}
	else
	{
		iID = (int)m_tvDecoder.GetItemData(hItem);
		if (m_iLastID == iID)
		{
			return;
		}

		HTREEITEM hChildItem = m_tvDecoder.GetChildItem(hItem);
		if (hChildItem != NULL)
		{
			iChannel = (int)m_tvDecoder.GetItemData(hChildItem);
		}
	}

	m_iLastChannel = iChannel;
	int iPos = 0;//GetComboData(&m_cboPos);
	m_iLastID = iID;
	if (iID == -1){
		UpdateChannelInfo(iID,0,0);
		return;
	}
	UpdateChannelInfo(iID,iChannel,iPos);

	ChangeAlarmNotify(iID);

	UpdatePosNum(iID, iChannel);
}

int CMainViewDlg::UpdateChannelInfo(int _iID,int _iChannel,int _iPos)
{
// 	if(_iChannel<0 || _iChannel>=(DEC_MAX_CHANNEL_NUM_NEW+DEC_MAX_VIRTUAL_CHANNEL_NUM))
// 	{
// 		return -1;
// 	}

// 	if (_iID < 0)
// 	{
// 		return -1;
// 	}
 	UpdateDECPos(_iID,_iChannel,_iPos);
	int iPos =  GetComboData(&m_cboPos);
	UpdateNVSItems(_iID,_iChannel,iPos);
	UpdateDECVersion(_iID);
	UpdateDECInfo(_iID,_iChannel,iPos);
	UpdateAudioStatus(_iID, _iChannel, iPos);
	UpdateTalkStatus(_iID, _iChannel, iPos);
	UpdateSwitchStatus(_iID, _iChannel, iPos);
	UpdatePushStreamAudioStatus(_iID, _iChannel, iPos);
	UpdateSinglePicture();

	return 0;
}

int CMainViewDlg::UpdateDECVersion(int _iID)
{
	char cVer[32] = {0};       
	if (_iID >= 0)
	{
		DEC_ClientGetVersion(_iID,cVer);//3.汾
	}
	SetDlgItemText(IDC_STATIC_VERSION,(LPCTSTR)cVer);

	return 0;
}

int CMainViewDlg::UpdateNVSItem( int _iItem,int iType, ServerItem& _tServerItem )
{
	CString strServerIP,strChannel,strHoldTime,strPort,strAddress;
	int iItem = m_lstNvs.GetItemCount();
	int iSubItem = 1;
	
	ViewServerInfo tServer = {0};
	ConvertItemEx(&_tServerItem, iType, tServer);
	//rtsp
	if (DEVTYPE_RTSP == iType)
	{
		strServerIP.Format(_T("%s"), tServer.rtsp_url);
		if (_iItem >= 0 && _iItem < iItem)
		{
			iItem = _iItem;
			
			m_lstNvs.SetItemText(iItem,0,strServerIP);//IP/DDNS/DSM
		}
		else
		{
			m_lstNvs.InsertItem(iItem,strServerIP,STATE_OFFLINE);//IP/DDNS/DSM
		}
	}
	else
	{
		strServerIP.Format(_T("%s"), tServer.con_mode == 0 ? tServer.ser_ip : tServer.ser_name);
		if (_iItem >= 0 && _iItem < iItem)
		{
			iItem = _iItem;
			m_lstNvs.SetItemText(iItem,0,strServerIP);//IP/DDNS/DSM
		}
		else
		{
			m_lstNvs.InsertItem(iItem,strServerIP,STATE_OFFLINE);//IP/DDNS/DSM
		}
		if (strcmp(tServer.ser_proxy,"NOPROXY") == 0)
		{
			strcpy_s(tServer.ser_proxy,1,"");
		}
	}

	strChannel.Format(_T("%d"),tServer.ser_ch_no+1);
	m_lstNvs.SetItemText(iItem,iSubItem++,strChannel);//channel

	m_lstNvs.SetItemText(iItem,iSubItem++,tServer.ser_stream_no == 0 ? GetText(IDS_MAIN_STREAM_MAIN) : GetText(IDS_MAIN_STREAM_SUB));//stream

	switch (tServer.ser_net_mode)//net mode
	{
	case 0:
		m_lstNvs.SetItemText(iItem,iSubItem++,GetText(IDS_MAIN_NET_MODE_TCP));
		break;
	case 1:
		m_lstNvs.SetItemText(iItem,iSubItem++,GetText(IDS_MAIN_NET_MODE_TCP));
		break;
	case 2:
		m_lstNvs.SetItemText(iItem,iSubItem++,GetText(IDS_MAIN_NET_MODE_UDP));
		break;
	case 3:
		m_lstNvs.SetItemText(iItem,iSubItem++,GetText(IDS_MAIN_NET_MODE_MUT));
		break;
	}
	
	strHoldTime.Format(_T("%d"),tServer.hold_time);
	m_lstNvs.SetItemText(iItem,iSubItem++,strHoldTime);//hold time

	if (DEVTYPE_RTSP == iType)
	{
		m_lstNvs.SetItemText(iItem,iSubItem++,"");//proxy ip
	}
	else
	{
		m_lstNvs.SetItemText(iItem,iSubItem++,(LPCTSTR)tServer.ser_proxy);//proxy ip
	}

	strPort.Format(_T("%d"),tServer.ser_port);
	m_lstNvs.SetItemText(iItem,iSubItem++,strPort);//port

	if (tServer.con_mode == 0)//connect mode
	{
		m_lstNvs.SetItemText(iItem,iSubItem++,GetText(IDS_MAIN_CONNECT_MODE_IP));//by ip
	}
	else if (tServer.con_mode == 1)
	{
		m_lstNvs.SetItemText(iItem,iSubItem++,GetText(IDS_MAIN_CONNECT_MODE_DDNS));//by ddns
	}
	else
	{
		m_lstNvs.SetItemText(iItem,iSubItem++,GetText(IDS_MAIN_CONNECT_MODE_DSM));//by active
	}

	m_lstNvs.SetItemText(iItem,iSubItem++,(LPCTSTR)tServer.ser_usr_name);//username

	m_lstNvs.SetItemText(iItem, iSubItem++, _T("*****"));//password

	m_lstNvs.SetItemText(iItem,iSubItem++,(LPCTSTR)tServer.ser_ptz_protocol);//device type

	strAddress.Format(_T("%d"),tServer.ser_ptz_addr+1);		//豸ַʾʱ1
	m_lstNvs.SetItemText(iItem,iSubItem++,strAddress);//address

	m_lstNvs.SetItemText(iItem,iSubItem++,(LPCTSTR)tServer.ser_usr_pwd);//password

	m_lstNvs.SetItemText(iItem, iSubItem++, _T("*****"));	//encrypt password
	CString strDevPlatType;
	switch(iType)
	{
		case DEVTYPE_NORMAL:
			strDevPlatType = "Normal";
			break;
		case DEVTYPE_ONVIF:
			strDevPlatType = "Onvif";
			break;
		case DEVTYPE_RTSP:
			strDevPlatType = "RTSP";
			break;
		case DEVTYPE_ENCODE:
			strDevPlatType = "Encode Card";
			break;
		case DEVTYPE_LOCAL:
			strDevPlatType = "Local Input";
			break;
		case DEVTYPE_LG:
			strDevPlatType = "Onvif_LG";
			break;
		case DEVTYPE_PANASONIC:
			strDevPlatType = "Onvif_Panasonic";
			break;
	}

	/*strDevPlatType.Format(_T("%d"), iType);*/
	m_lstNvs.SetItemText(iItem, iSubItem++, strDevPlatType);

	m_lstNvs.SetItemText(iItem,iSubItem++,(LPCTSTR)tServer.video_dec_pwd);

	if (iType == DEVTYPE_RTSP)
	{
		m_lstNvs.SetItemText(iItem,iSubItem++,(LPCTSTR)tServer.mult_ip);
		CString cstrMultPort;
		cstrMultPort.Format(_T("%d"), tServer.mult_port);
		m_lstNvs.SetItemText(iItem,iSubItem++,cstrMultPort);
	}



	return iItem;
}

int CMainViewDlg::UpdateNvsServer(int _iItem, ViewServerInfo& _tNvsServer)
{
	CString strServerIP,strChannel,strHoldTime,strPort,strAddress;
	int iItem = m_lstNvs.GetItemCount();
	int iSubItem = 1;
	int iType = _tNvsServer.ser_type;
	//rtsp
	if (DEVTYPE_RTSP == iType)
	{
		strServerIP.Format(_T("%s"), _tNvsServer.rtsp_url);
		if (_iItem >= 0 && _iItem < iItem)
		{
			iItem = _iItem;
			m_lstNvs.SetItemText(iItem,0,strServerIP);//IP/DDNS/DSM
		}
		else
		{
			m_lstNvs.InsertItem(iItem,strServerIP,STATE_OFFLINE);//IP/DDNS/DSM
		}
	}
	else
	{
		strServerIP.Format(_T("%s"), _tNvsServer.con_mode == 0 ? _tNvsServer.ser_ip : _tNvsServer.ser_name);
		if (_iItem >= 0 && _iItem < iItem)
		{
			iItem = _iItem;
			m_lstNvs.SetItemText(iItem,0,strServerIP);//IP/DDNS/DSM
		}
		else
		{
			m_lstNvs.InsertItem(iItem,strServerIP,STATE_OFFLINE);//IP/DDNS/DSM
		}
		if (strcmp(_tNvsServer.ser_proxy,"NOPROXY") == 0)
		{
			strcpy_s(_tNvsServer.ser_proxy,1,"");
		}
	}

	strChannel.Format(_T("%d"),_tNvsServer.ser_ch_no+1);
	m_lstNvs.SetItemText(iItem,iSubItem++,strChannel);//channel

	m_lstNvs.SetItemText(iItem,iSubItem++,_tNvsServer.ser_stream_no == 0 ? GetText(IDS_MAIN_STREAM_MAIN) : GetText(IDS_MAIN_STREAM_SUB));//stream

	switch (_tNvsServer.ser_net_mode)//net mode
	{
	case 0:
		m_lstNvs.SetItemText(iItem,iSubItem++,GetText(IDS_MAIN_NET_MODE_TCP));
		break;
	case 1:
		m_lstNvs.SetItemText(iItem,iSubItem++,GetText(IDS_MAIN_NET_MODE_TCP));
		break;
	case 2:
		m_lstNvs.SetItemText(iItem,iSubItem++,GetText(IDS_MAIN_NET_MODE_UDP));
		break;
	case 3:
		m_lstNvs.SetItemText(iItem,iSubItem++,GetText(IDS_MAIN_NET_MODE_MUT));
		break;
	}

	strHoldTime.Format(_T("%d"),_tNvsServer.hold_time);
	m_lstNvs.SetItemText(iItem,iSubItem++,strHoldTime);//hold time

	if (DEVTYPE_RTSP == iType)
	{
		m_lstNvs.SetItemText(iItem,iSubItem++,"");//proxy ip
	}
	else
	{
		m_lstNvs.SetItemText(iItem,iSubItem++,(LPCTSTR)_tNvsServer.ser_proxy);//proxy ip
	}

	strPort.Format(_T("%d"),_tNvsServer.ser_port);
	m_lstNvs.SetItemText(iItem,iSubItem++,strPort);//port

	if (_tNvsServer.con_mode == 0)//connect mode
	{
		m_lstNvs.SetItemText(iItem,iSubItem++,GetText(IDS_MAIN_CONNECT_MODE_IP));//by ip
	}
	else if (_tNvsServer.con_mode == 1)
	{
		m_lstNvs.SetItemText(iItem,iSubItem++,GetText(IDS_MAIN_CONNECT_MODE_DDNS));//by ddns
	}
	else
	{
		m_lstNvs.SetItemText(iItem,iSubItem++,GetText(IDS_MAIN_CONNECT_MODE_DSM));//by active
	}

	m_lstNvs.SetItemText(iItem,iSubItem++,(LPCTSTR)_tNvsServer.ser_usr_name);//username

	m_lstNvs.SetItemText(iItem, iSubItem++, _T("*****"));//password

	m_lstNvs.SetItemText(iItem,iSubItem++,(LPCTSTR)_tNvsServer.ser_ptz_protocol);//device type

	strAddress.Format(_T("%d"),_tNvsServer.ser_ptz_addr+1);		//豸ַʾʱ1
	m_lstNvs.SetItemText(iItem,iSubItem++,strAddress);//address

	m_lstNvs.SetItemText(iItem,iSubItem++,(LPCTSTR)_tNvsServer.ser_usr_pwd);//password

	m_lstNvs.SetItemText(iItem, iSubItem++, _T("*****"));	//encrypt password
	CString strDevPlatType;
	switch(iType)
	{
	case DEVTYPE_NORMAL:
		strDevPlatType = "Normal";
		break;
	case DEVTYPE_ONVIF:
		strDevPlatType = "Onvif";
		break;
	case DEVTYPE_RTSP:
		strDevPlatType = "RTSP";
		break;
	case DEVTYPE_ENCODE:
		strDevPlatType = "Encode Card";
		break;
	case DEVTYPE_LOCAL:
		strDevPlatType = "Local Input";
		break;
	case DEVTYPE_LG:
		strDevPlatType = "Onvif_LG";
		break;
	case DEVTYPE_PANASONIC:
		strDevPlatType = "Onvif_Panasonic";
		break;
	}

	/*strDevPlatType.Format(_T("%d"), iType);*/
	m_lstNvs.SetItemText(iItem, iSubItem++, strDevPlatType);

	m_lstNvs.SetItemText(iItem,iSubItem++,(LPCTSTR)_tNvsServer.video_dec_pwd);

	if (iType == DEVTYPE_RTSP)
	{
		m_lstNvs.SetItemText(iItem,iSubItem++,(LPCTSTR)_tNvsServer.mult_ip);
		CString cstrMultPort;
		cstrMultPort.Format(_T("%d"), _tNvsServer.mult_port);
		m_lstNvs.SetItemText(iItem,iSubItem++,cstrMultPort);
	}

	return iItem;
}

int CMainViewDlg::AddNvsItem(int iType, ServerItem& _tNvsItem)
{
	return UpdateNVSItem(-1, iType, _tNvsItem);
}

int CMainViewDlg::UpdateNVSItems( int _iID,int _iChannel,int _iPos )
{
// 	if(_iChannel<0 || _iChannel>=(DEC_MAX_CHANNEL_NUM_NEW+DEC_MAX_VIRTUAL_CHANNEL_NUM))
// 	{
// 		return -1;
// 	}

	int iItem = 0;
	POSITION pos = m_lstNvs.GetFirstSelectedItemPosition();
	if (pos)
	{
		iItem = m_lstNvs.GetNextSelectedItem(pos);
		if (iItem < 0)
		{
			iItem = 0;
		}
	}

	m_lstNvs.DeleteAllItems();
	if (_iID < 0)
	{
		return -1;
	}

	int iLoopCount = 0;
	
	iLoopCount = DEC_ClientGetLoopItemCount(_iID,_iChannel,_iPos);

	CString cstrTotalCount;
	cstrTotalCount.Format("Total: %d", iLoopCount);
	SetDlgItemText(IDC_STATIC_TOTAL_NVS_COUNT, cstrTotalCount);

	//б
	for (int i = 0; i < iLoopCount; ++i)
	{
		int iType = 0;
		ServerItem tServerItem = {0};
		tServerItem.iSize = sizeof(ServerItem);
		if (DEC_ClientGetLoopItem_V1(_iID,_iChannel,_iPos, i, &iType, &tServerItem) == 0)
		{
			AddNvsItem(iType, tServerItem);
		}
	}

	UpdateNVSItemStatus(_iID,_iChannel,_iPos);

	m_lstNvs.SetItemState(iItem,LVIS_SELECTED,LVIS_SELECTED);

	return 0;
}

int CMainViewDlg::UpdateNVSItemStatus( int _iID,int _iChannel,int _iPos)
{
// 	if(_iChannel<0 || _iChannel>=(DEC_MAX_CHANNEL_NUM_NEW+DEC_MAX_VIRTUAL_CHANNEL_NUM))
// 	{
// 		return -1;
// 	}

	if (_iID == GetCurrentID() && _iChannel == GetCurrentChannel() && _iPos == GetCurrentPos())
	{
		//TNVSITEMEX tNvsItem = {0};
		//tNvsItem.m_iStructLen = sizeof(TNVSITEMEX);
		//int iRet = DEC_ClientGetViewItemEx(_iID, &tNvsItem, _iChannel, _iPos);
		//if (iRet < 0)
		//{
		//	AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::UpdateNVSItemStatus] Get View Item Failed! Ret(%d),Error(0x%08x),ID(%d),Channel(%d),Pos(%d)"
		//		,iRet,GetLastError(),_iID,_iChannel,_iPos);
		//}

		ServerItem tServerItem = {0};
		int iServerType = DEVTYPE_NORMAL;
		int iRet = DEC_ClientGetViewItem_V1(_iID, _iChannel, _iPos, &iServerType, &tServerItem);
		if (iRet < 0)
		{
			AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::UpdateNVSItemStatus] Get View Item Failed! Ret(%d),Error(0x%08x),ID(%d),Channel(%d),Pos(%d)"
				,iRet,GetLastError(),_iID,_iChannel,_iPos);
		}

		LVITEM tItem = {0}; 
		tItem.mask = LVIF_IMAGE;
		CString strServerIP;
		for (int i=0;i<m_lstNvs.GetItemCount();++i)
		{					
			tItem.iItem = i;
			strServerIP = m_lstNvs.GetItemText(i,0);
			CString strChannel = m_lstNvs.GetItemText(i,1);
			CString strStream = m_lstNvs.GetItemText(i, 2);
			CString strPort = m_lstNvs.GetItemText(i,6);
			CString strDevPlatType = m_lstNvs.GetItemText(i,14);
			CString strServer;
			int iDevPlatType = DEVTYPE_NORMAL;

			if (strDevPlatType == "RTSP")				//
			{
				iDevPlatType = DEVTYPE_RTSP;
			}
			else if (strDevPlatType == "Onvif")
			{
				iDevPlatType= DEVTYPE_ONVIF;
			}
			else if (strDevPlatType == "Encode Card")
			{
				iDevPlatType = DEVTYPE_ENCODE;
			}
			else if (strDevPlatType == "Local Input")
			{
				iDevPlatType = DEVTYPE_LOCAL;
			}
			else if (strDevPlatType == "Onvif_LG")
			{
				iDevPlatType= DEVTYPE_LG;
			}
			else if (strDevPlatType == "Onvif_Panasonic")
			{
				iDevPlatType= DEVTYPE_PANASONIC;
			}
			else
			{
				iDevPlatType = DEVTYPE_NORMAL;
			}

			if (DEVTYPE_RTSP == iServerType)
			{
				strServer.Format("%s", tServerItem.tRtsp.cRtspUrl);
				if (strServerIP.CompareNoCase(strServer) == 0
					&& iRet == ERR_ISVIEW
					&& iServerType == iDevPlatType)
				{
					tItem.iImage = STATE_ONLINE;
				}
				else
				{
					tItem.iImage = STATE_OFFLINE;
				}
			}
			else if (DEVTYPE_ONVIF == iServerType || DEVTYPE_LG == iServerType || DEVTYPE_PANASONIC == iServerType)
			{
				strServer.Format("%s",tServerItem.tOnvif.tCommonInfo.cServerIp);//onvifǰûģʽ
				if (strServerIP.CompareNoCase(strServer) == 0 && 
					tServerItem.tOnvif.tCommonInfo.iServerChannelNo + 1 == atoi((LPSTR)(LPCTSTR)strChannel) && 
					tServerItem.tOnvif.tCommonInfo.iServerStreamNo == (GetText(IDS_MAIN_STREAM_MAIN) == strStream ? 0:1) && 
					tServerItem.tOnvif.tCommonInfo.iServerPort == atoi((LPSTR)(LPCTSTR)strPort) &&
					iServerType== iDevPlatType
					&& iRet == ERR_ISVIEW)
				{
					tItem.iImage = STATE_ONLINE;
				}
				else
				{
					tItem.iImage = STATE_OFFLINE;
				}
			}
			else if (DEVTYPE_ENCODE == iServerType || DEVTYPE_LOCAL == iServerType )
			{
				if (tServerItem.tOnvif.tCommonInfo.iServerChannelNo + 1 == atoi((LPSTR)(LPCTSTR)strChannel) && iRet == ERR_ISVIEW
					&& iServerType == iDevPlatType)
				{
					tItem.iImage = STATE_ONLINE;
				}
				else
				{
					tItem.iImage = STATE_OFFLINE;
				}
			}
			else
			{
				if (0 == tServerItem.tNormal.iConnectMode)
				{
					strServer.Format("%s",tServerItem.tNormal.tCommonInfo.cServerIp);
				}
				else
				{
					strServer.Format("%s",tServerItem.tNormal.cServerName);
				}

				if (strServerIP.CompareNoCase(strServer) == 0 && 
					tServerItem.tNormal.tCommonInfo.iServerChannelNo + 1 == atoi((LPSTR)(LPCTSTR)strChannel) && 
					tServerItem.tNormal.tCommonInfo.iServerStreamNo == (GetText(IDS_MAIN_STREAM_MAIN) == strStream ? 0:1) && 
					tServerItem.tNormal.tCommonInfo.iServerPort == atoi((LPSTR)(LPCTSTR)strPort) &&
					iServerType == iDevPlatType
					&& iRet == ERR_ISVIEW)
				{
					tItem.iImage = STATE_ONLINE;
				}
				else
				{
					tItem.iImage = STATE_OFFLINE;
				}
			}
			m_lstNvs.SetItem(&tItem);
		}

		// ˸бݣҪƵԽ״̬ [12/15/2011 hanyongqiang]
		UpdateAudioStatus(_iID, _iChannel, _iPos);
		UpdateTalkStatus(_iID, _iChannel, _iPos);

		return 0;
	}

	return -1;
}

int CMainViewDlg::UpdateDECPos(int _iID,int _iChannel,int _iPos)
{
	if (_iID < 0)
	{
		m_cboPos.ResetContent();
		//m_cboPos.SetCurSel(0);
		//m_cboPos.EnableWindow(FALSE);
		return -1;
	}
	CreatePosCombo(_iID, _iChannel, _iPos, &m_cboPos,1);
	return 0;
}


void CMainViewDlg::OnBnClickedButtonCtrl()
{
	TNVSITEMEX nvs = {0};
	nvs.m_iStructLen = sizeof(TNVSITEMEX);
	if (DEC_ClientGetViewItemEx(GetCurrentID(), &nvs, GetCurrentChannel(), GetCurrentPos())!=1)
	{
		MessageBox(GetText(IDS_MAIN_NOCONNECT),"",MB_OK|MB_TOPMOST);
		return;
	}
	//ʱô޸
	CDeviceCtrl dlgDeviceCtrl;
	dlgDeviceCtrl.Initialize(GetCurrentID(), /*0 ,0*/GetCurrentChannel(), GetCurrentPos());
	dlgDeviceCtrl.DoModal();
}

void CMainViewDlg::OnCbnSelchangeComboPos()
{
	HTREEITEM hItem = m_tvDecoder.GetSelectedItem();
	if (hItem == NULL)
	{
		return;
	}

	int iID = -1;
	int iChannel = 0;
	HTREEITEM hParentItem = m_tvDecoder.GetParentItem(hItem);
	if (hParentItem)
	{
		iID = (int)m_tvDecoder.GetItemData(hParentItem);
		iChannel = (int)m_tvDecoder.GetItemData(hItem);
	}
	else
	{
		iID = (int)m_tvDecoder.GetItemData(hItem);
		HTREEITEM hChildItem = m_tvDecoder.GetChildItem(hItem);
		if (hChildItem != NULL)
		{
			iChannel = (int)m_tvDecoder.GetItemData(hChildItem);
		}
	}

	int iPos = m_cboPos.GetCurSel();
	UpdateChannelInfo(iID,iChannel,iPos);
}

int CMainViewDlg::UpdateDECInfo( int _iID,int _iChannel,int _iPos )
{
	CString strInfo;
	if (_iID >= 0)
	{
		HTREEITEM hItem = FindItem(_iID);
		if (hItem)
		{
			CString strIP = m_tvDecoder.GetItemText(hItem);
			CString strChannel;
			CString strPicture;
			int iChannlNo = -1;
			int iPictureNo = -1;
			BaseOffset tOffset = {0};
			tOffset.iSize = sizeof(BaseOffset);
			DEC_ClientGetDevConfig(_iID, 0, 0, CMD_DEC_CFG_BASE_OFFSET, &tOffset, sizeof(BaseOffset));
			if (_iChannel < DEC_MAX_PHYSICAL_CHANNEL_NUM)
			{
				strChannel = GetText(IDS_MAIN_CHANNEL);
				iChannlNo = _iChannel + 1;
			}
			else
			{
				strChannel = GetText(IDS_SETTING_MULI_SCREEN_TITLE);
				iChannlNo = _iChannel - tOffset.iSplitScreen + 1;
			}

			if (_iPos < DEC_MAX_PICTURE_NUM)
			{
				strPicture = GetText(IDS_MAIN_SCREEN);
				iPictureNo = _iPos + 1;
			} 
			else
			{
				strPicture = GetText(IDS_CFG_POP_UP_WINDOW);
				iPictureNo = _iPos - tOffset.iFloatWindow + 1;
			}

			strInfo.Format(_T("%s/%s %d/%s %d"), strIP, strChannel
				, iChannlNo, strPicture, iPictureNo);
		}
	}

	SetDlgItemText(IDC_STATIC_DECODER_INFO,strInfo);

	return 0;
}

void CMainViewDlg::OnNMRClickListNvs(NMHDR *pNMHDR, LRESULT* /*pResult*/)
{
	CString strAutoSwitch;
	GetDlgItemText(IDC_BUTTON_AUTO_SWITCH,strAutoSwitch);
	if (strAutoSwitch.CompareNoCase(GetText(IDS_MAIN_STOPAUTOSWITCH)) == 0)
	{
		return;
	}

	LPNMITEMACTIVATE pItem = reinterpret_cast<NMITEMACTIVATE*>(pNMHDR);
	if (pItem->iItem < 0)
	{
		return;
	}

	CMenu menu;
	menu.CreatePopupMenu();
	menu.AppendMenu(MF_STRING, ID_NVS_CONNECT, GetText(IDS_MENU_NVS_CONNECT));
	menu.AppendMenu(MF_STRING, ID_NVS_DISCONNECT, GetText(IDS_MENU_NVS_DISCONNECT));
	menu.AppendMenu(MF_STRING, ID_NVS_MODIFY, GetText(IDS_MENU_NVS_MODIFY));
	menu.AppendMenu(MF_STRING, ID_NVS_DELETE, GetText(IDS_MENU_NVS_DELETE));

	LVITEM tItem = {0}; 
	tItem.iItem = pItem->iItem;
	tItem.mask = LVIF_IMAGE;
	m_lstNvs.GetItem(&tItem);
	if (STATE_OFFLINE == tItem.iImage)
	{
		menu.EnableMenuItem(ID_NVS_DISCONNECT,MF_GRAYED);
	}
	else if (STATE_ONLINE == tItem.iImage)
	{
		menu.EnableMenuItem(ID_NVS_CONNECT,MF_GRAYED);
		menu.EnableMenuItem(ID_NVS_MODIFY,MF_GRAYED);
		menu.EnableMenuItem(ID_NVS_DELETE,MF_GRAYED);
	}

	POINT& ptCursor = pItem->ptAction;
	m_lstNvs.ClientToScreen(&ptCursor);
	menu.TrackPopupMenu(TPM_LEFTALIGN | TPM_RIGHTBUTTON,ptCursor.x,ptCursor.y,this);
	menu.DestroyMenu();
}

void CMainViewDlg::OnNvsConnect()
{
	POSITION pos = m_lstNvs.GetFirstSelectedItemPosition();
	if (pos)
	{
		int iItem = m_lstNvs.GetNextSelectedItem(pos);
		if (iItem >= 0)
		{
			Connect(iItem);
		}
	}
}

void CMainViewDlg::OnNvsDisconnect()
{
	POSITION pos = m_lstNvs.GetFirstSelectedItemPosition();
	if (pos)
	{
		int iItem = m_lstNvs.GetNextSelectedItem(pos);
		if (iItem >= 0)
		{
			Disconnect(iItem);
		}
	}
}

void CMainViewDlg::OnNvsModify()
{
	POSITION pos = m_lstNvs.GetFirstSelectedItemPosition();
	if (pos)
	{
		int iItem = m_lstNvs.GetNextSelectedItem(pos);
		if (iItem >= 0)
		{
			//TNVSITEMEX tNvsItem = {0};
			//tNvsItem.m_iStructLen = sizeof(TNVSITEMEX);
			//GetNvsItem(iItem,tNvsItem);
			//ModifyNvs(iItem,tNvsItem);

			ViewServerInfo tViewServer = {0};
			GetNvsServer(iItem, tViewServer);
			ModifyNvsEx(iItem, tViewServer);
		}
	}
}

void CMainViewDlg::OnNvsDelete()
{
	POSITION pos = m_lstNvs.GetFirstSelectedItemPosition();
	if (pos)
	{
		int iItem = m_lstNvs.GetNextSelectedItem(pos);
		if (iItem >= 0)
		{
			DeleteNvs(iItem);
		}
	}
}

int CMainViewDlg::GetNvsItem(int _iItem,TNVSITEMEX& _tNvsItem)
{
	int iSubItem = 0;
	CString strServerIP = m_lstNvs.GetItemText(_iItem,iSubItem++);
	//ǰ
	CString strUseDdns = m_lstNvs.GetItemText(_iItem,7);
	if (strUseDdns.CompareNoCase(GetText(IDS_MAIN_CONNECT_MODE_DSM)) == 0)
	{
		_tNvsItem.m_stOldItem.m_bUseddns = 2;
	}
	else if (strUseDdns.CompareNoCase(GetText(IDS_MAIN_CONNECT_MODE_DDNS)) == 0)
	{
		_tNvsItem.m_stOldItem.m_bUseddns = 1;
	}
	else
	{
		_tNvsItem.m_stOldItem.m_bUseddns = 0;
	}

	CString strDevPlatType1 = m_lstNvs.GetItemText(_iItem, 14);
	char cDevPlatType[128] = {0};
	strcpy_s(cDevPlatType, (LPSTR)(LPCTSTR)strDevPlatType1);
	if (!strcmp(cDevPlatType, "RTSP"))				//
	{
		strcpy_s(_tNvsItem.m_stOldItem.m_cRTSPUrl, strServerIP.GetLength()+1,(LPCSTR)(LPCTSTR)strServerIP);
	}
	else
	{
		if (_tNvsItem.m_stOldItem.m_bUseddns)
		{
			strcpy_s(_tNvsItem.m_stOldItem.m_serName,strServerIP.GetLength()+1,(LPCSTR)(LPCTSTR)strServerIP);
		}
		else
		{
			strcpy_s(_tNvsItem.m_stOldItem.m_serIP,strServerIP.GetLength()+1,(LPCSTR)(LPCTSTR)strServerIP);
		}
	}

	CString strChannel = m_lstNvs.GetItemText(_iItem,iSubItem++);
	_tNvsItem.m_stOldItem.m_serChan = atoi((LPCSTR)(LPCTSTR)strChannel) - 1;

	CString strStream = m_lstNvs.GetItemText(_iItem,iSubItem++);
	if (strStream.CompareNoCase(GetText(IDS_MAIN_STREAM_MAIN)) == 0)
	{
		_tNvsItem.m_stOldItem.m_serStream = 0;
	}
	else
	{
		_tNvsItem.m_stOldItem.m_serStream = 1;
	}

	CString strNetMode = m_lstNvs.GetItemText(_iItem,iSubItem++);
	if (strNetMode.CompareNoCase(_T("TCP")) == 0)
	{
		_tNvsItem.m_stOldItem.m_serNetmode = 1;
	}
	else if (strNetMode.CompareNoCase(_T("UDP")) == 0)
	{
		_tNvsItem.m_stOldItem.m_serNetmode = 2;
	}
	else if (strNetMode.CompareNoCase(_T("MUT")) == 0)
	{
		_tNvsItem.m_stOldItem.m_serNetmode = 3;
	}

	CString strHoldTime = m_lstNvs.GetItemText(_iItem,iSubItem++);
	_tNvsItem.m_stOldItem.m_holdtime = atoi((LPCSTR)(LPCTSTR)strHoldTime);

	CString strProxyIP = m_lstNvs.GetItemText(_iItem,iSubItem++);
	if (!strcmp(cDevPlatType, "RTSP"))				//
	{
		//strcpy_s(_tNvsItem.m_stOldItem.m_serProxy, "");
	}
	else
	{
		strcpy_s(_tNvsItem.m_stOldItem.m_serProxy, strProxyIP.GetLength()+1, (LPCSTR)(LPCTSTR)strProxyIP);
	}

	CString strPort = m_lstNvs.GetItemText(_iItem,iSubItem++);
	_tNvsItem.m_stOldItem.m_serPort = atoi((LPCSTR)(LPCTSTR)strPort);

	iSubItem = 8;
	CString strUserName = m_lstNvs.GetItemText(_iItem,iSubItem++);
	strcpy_s(_tNvsItem.m_stOldItem.m_username,strUserName.GetLength()+1,(LPCSTR)(LPCTSTR)strUserName);

	iSubItem++;//һз******,().

	CString strDeviceType = m_lstNvs.GetItemText(_iItem,iSubItem++);
	strcpy_s(_tNvsItem.m_stOldItem.m_deviceType,strDeviceType.GetLength()+1,(LPCSTR)(LPCTSTR)strDeviceType);

	CString strAddress = m_lstNvs.GetItemText(_iItem,iSubItem++);
	_tNvsItem.m_stOldItem.m_iAddress = atoi((LPCSTR)(LPCTSTR)strAddress);

	CString strPassword = m_lstNvs.GetItemText(_iItem,iSubItem++);
	strcpy_s(_tNvsItem.m_stOldItem.m_password,strPassword.GetLength()+1,(LPCSTR)(LPCTSTR)strPassword);

	iSubItem++;	//һз******,().

	CString strDevPlatType = m_lstNvs.GetItemText(_iItem, iSubItem++);
	if (strcmp(cDevPlatType, "RTSP") == 0)				//
	{
		_tNvsItem.m_iDevPlatType = DEVTYPE_RTSP;
	}
	else if (strcmp(cDevPlatType, "Onvif") == 0)
	{
		_tNvsItem.m_iDevPlatType = DEVTYPE_ONVIF;
	}
	else if (strcmp(cDevPlatType, "Encode Card") == 0)
	{
		_tNvsItem.m_iDevPlatType = DEVTYPE_ENCODE;
	}
	else if (strcmp(cDevPlatType, "Local Input") == 0)
	{
		_tNvsItem.m_iDevPlatType = DEVTYPE_LOCAL;
	}
	else if (0 == strcmp(cDevPlatType, "Onvif_LG"))
	{
		_tNvsItem.m_iDevPlatType = DEVTYPE_LG;
	}
	else if (0 == strcmp(cDevPlatType, "Onvif_Panasonic"))
	{
		_tNvsItem.m_iDevPlatType = DEVTYPE_PANASONIC;
	}
	else
	{
		_tNvsItem.m_iDevPlatType = DEVTYPE_NORMAL;
	}

	CString strEncrytPWD = m_lstNvs.GetItemText(_iItem, iSubItem++);
	strcpy_s(_tNvsItem.m_cEncyptPWD, (LPCSTR)(LPCTSTR)strEncrytPWD);

	CString strMultIP = m_lstNvs.GetItemText(_iItem, iSubItem++);
	strcpy_s(_tNvsItem.m_cMultIP, (LPCSTR)(LPCTSTR)strMultIP);

	CString strMultPort = m_lstNvs.GetItemText(_iItem, iSubItem++);
	_tNvsItem.m_iMultPort = atoi((LPCSTR)(LPCTSTR)strMultPort);

	return 0;
}

int CMainViewDlg::GetNvsServer(int _iItem, ViewServerInfo& _tNvsServer)
{
	int iSubItem = 0;
	CString strServerIP = m_lstNvs.GetItemText(_iItem,iSubItem++);
	//ǰ
	CString strUseDdns = m_lstNvs.GetItemText(_iItem,7);
	if (strUseDdns.CompareNoCase(GetText(IDS_MAIN_CONNECT_MODE_DSM)) == 0)
	{
		_tNvsServer.con_mode = 2;
	}
	else if (strUseDdns.CompareNoCase(GetText(IDS_MAIN_CONNECT_MODE_DDNS)) == 0)
	{
		_tNvsServer.con_mode = 1;
	}
	else
	{
		_tNvsServer.con_mode = 0;
	}

	CString strDevPlatType1 = m_lstNvs.GetItemText(_iItem, 14);
	char cDevPlatType[DEC_LEN_128] = {0};
	strcpy_s(cDevPlatType, (LPSTR)(LPCTSTR)strDevPlatType1);
	if (!strcmp(cDevPlatType, "RTSP"))				//
	{
		strcpy_s(_tNvsServer.rtsp_url, strServerIP.GetLength()+1, (LPCSTR)(LPCTSTR)strServerIP);
	}
	else
	{
		if (_tNvsServer.con_mode != 0)
		{
			strcpy_s(_tNvsServer.ser_name, strServerIP.GetLength()+1, (LPCSTR)(LPCTSTR)strServerIP);
		}
		else
		{
			strcpy_s(_tNvsServer.ser_ip, strServerIP.GetLength()+1, (LPCSTR)(LPCTSTR)strServerIP);
		}
	}

	CString strChannel = m_lstNvs.GetItemText(_iItem,iSubItem++);
	_tNvsServer.ser_ch_no = atoi((LPCSTR)(LPCTSTR)strChannel) - 1;

	CString strStream = m_lstNvs.GetItemText(_iItem,iSubItem++);
	if (strStream.CompareNoCase(GetText(IDS_MAIN_STREAM_MAIN)) == 0)
	{
		_tNvsServer.ser_stream_no = 0;
	}
	else
	{
		_tNvsServer.ser_stream_no = 1;
	}

	CString strNetMode = m_lstNvs.GetItemText(_iItem,iSubItem++);
	if (strNetMode.CompareNoCase(_T("TCP")) == 0)
	{
		_tNvsServer.ser_net_mode = 1;
	}
	else if (strNetMode.CompareNoCase(_T("UDP")) == 0)
	{
		_tNvsServer.ser_net_mode = 2;
	}
	else if (strNetMode.CompareNoCase(_T("MUT")) == 0)
	{
		_tNvsServer.ser_net_mode = 3;
	}

	CString strHoldTime = m_lstNvs.GetItemText(_iItem,iSubItem++);
	_tNvsServer.hold_time = atoi((LPCSTR)(LPCTSTR)strHoldTime);

	CString strProxyIP = m_lstNvs.GetItemText(_iItem,iSubItem++);
	if (!strcmp(cDevPlatType, "RTSP"))
	{
		//TODO:nothing,rtspûдip
	}
	else
	{
		strcpy_s(_tNvsServer.ser_proxy, strProxyIP.GetLength()+1, (LPCSTR)(LPCTSTR)strProxyIP);
	}

	CString strPort = m_lstNvs.GetItemText(_iItem,iSubItem++);
	_tNvsServer.ser_port = atoi((LPCSTR)(LPCTSTR)strPort);

	iSubItem = 8;
	CString strUserName = m_lstNvs.GetItemText(_iItem,iSubItem++);
	strcpy_s(_tNvsServer.ser_usr_name, strUserName.GetLength()+1, (LPCSTR)(LPCTSTR)strUserName);

	iSubItem++;//һз******,().

	CString strDeviceType = m_lstNvs.GetItemText(_iItem,iSubItem++);
	strcpy_s(_tNvsServer.ser_ptz_protocol, strDeviceType.GetLength()+1, (LPCSTR)(LPCTSTR)strDeviceType);

	CString strAddress = m_lstNvs.GetItemText(_iItem,iSubItem++);
	_tNvsServer.ser_ptz_addr = atoi((LPCSTR)(LPCTSTR)strAddress);

	CString strPassword = m_lstNvs.GetItemText(_iItem,iSubItem++);
	strcpy_s(_tNvsServer.ser_usr_pwd, strPassword.GetLength()+1, (LPCSTR)(LPCTSTR)strPassword);

	iSubItem++;	//һз******,().

	CString strDevPlatType = m_lstNvs.GetItemText(_iItem, iSubItem++);
	if (strcmp(cDevPlatType, "RTSP") == 0)				//
	{
		_tNvsServer.ser_type = DEVTYPE_RTSP;
	}
	else if (strcmp(cDevPlatType, "Onvif") == 0)
	{
		_tNvsServer.ser_type = DEVTYPE_ONVIF;
	}
	else if (strcmp(cDevPlatType, "Encode Card") == 0)
	{
		_tNvsServer.ser_type = DEVTYPE_ENCODE;
	}
	else if (strcmp(cDevPlatType, "Local Input") == 0)
	{
		_tNvsServer.ser_type = DEVTYPE_LOCAL;
	}
	else if (0 == strcmp(cDevPlatType, "Onvif_LG"))
	{
		_tNvsServer.ser_type = DEVTYPE_LG;
	}
	else if (0 == strcmp(cDevPlatType, "Onvif_Panasonic"))
	{
		_tNvsServer.ser_type = DEVTYPE_PANASONIC;
	}
	else
	{
		_tNvsServer.ser_type = DEVTYPE_NORMAL;
	}

	CString strEncrytPWD = m_lstNvs.GetItemText(_iItem, iSubItem++);
	strcpy_s(_tNvsServer.video_dec_pwd, (LPCSTR)(LPCTSTR)strEncrytPWD);

	CString strMultIP = m_lstNvs.GetItemText(_iItem, iSubItem++);
	strcpy_s(_tNvsServer.mult_ip, (LPCSTR)(LPCTSTR)strMultIP);

	CString strMultPort = m_lstNvs.GetItemText(_iItem, iSubItem++);
	_tNvsServer.mult_port = atoi((LPCSTR)(LPCTSTR)strMultPort);

	return 0;
}

int CMainViewDlg::Connect(int _iItem)
{
	int iID = GetCurrentID();
	if (iID < 0)
	{
		return -1;
	}

	int iChannel = GetCurrentChannel();
	int iPos  =  GetCurrentPos();
	int iRet = DEC_ClientGetLoopStatus(iID,iChannel,iPos);
	if (1 == iRet)
	{
		AddLog(LOG_LEVEL_WARN,"[CMainViewDlg::Connect] Looping!ID(%d),Channel(%d),Pos(%d)"
			,iID,iChannel,iPos);
		return -1;
	}

	//TNVSITEMEX tNvsItemEx ={0}; 
	//GetNvsItem(_iItem, tNvsItemEx);

	ViewServerInfo tServer = {0};
	StopViewPara tParam = {0};
	tParam.iSize = sizeof(StopViewPara);
	GetNvsServer(_iItem, tServer);

	m_tNextItem.m_iDecID = iID;
	m_tNextItem.m_iChan = iChannel;
	m_tNextItem.m_iPic = iPos;

	//tNvsItemEx.m_iStructLen = sizeof(TNVSITEMEX);
	m_tNextItem.m_tViewServer = tServer;

	int iShowLastPic = m_chkLastFrame.GetCheck();
	tParam.iChannel = iChannel;
	tParam.iPos = iPos;
	tParam.iSaveLastFrame = iShowLastPic;
	tParam.iSaveCfg = !m_chk_SaveCfg.GetCheck();
	if (DEC_ClientStopView_V1)//½ӿڣֹdemoϵNVDSDKʱҲýӿ
	{
		iRet = DEC_ClientStopView_V1(iID, &tParam, tParam.iSize);
	}
	else
	{
		iRet = DEC_ClientStopView(iID,iChannel,iPos,iShowLastPic);
	}
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::Disconnect] Stop View Failed! Ret(%d),Error(0x%08x),ID(%d),Channel(%d),Pos(%d),ShowLastFrame(%d)"
			,iRet,GetLastError(),iID,iChannel,iPos,iShowLastPic);
	}

	return 0;
}

int CMainViewDlg::Disconnect( int _iItem )
{
	int iID = GetCurrentID();
	if (iID < 0)
	{
		return -1;
	}
	StopViewPara tParam = {0};
	tParam.iSize = sizeof(tParam);
	int iChannel = GetCurrentChannel();
	int iPos  =  GetCurrentPos();
	int iRet = DEC_ClientGetLoopStatus(iID,iChannel,iPos);
	if (iRet == 1)
	{
		AddLog(LOG_LEVEL_WARN,"[CMainViewDlg::Disconnect] Looping!ID(%d),Channel(%d),Pos(%d)"
			,iID,iChannel,iPos);
		return -1;
	}

	int iShowLastPic = m_chkLastFrame.GetCheck();
	tParam.iChannel = iChannel;
	tParam.iPos = iPos;
	tParam.iSaveLastFrame = iShowLastPic;
	tParam.iSaveCfg = !m_chk_SaveCfg.GetCheck();
	if (DEC_ClientStopView_V1)//½ӿڣֹdemoϵNVDSDKʱҲýӿ
	{
		iRet = DEC_ClientStopView_V1(iID, &tParam,tParam.iSize);
	}
	else
	{
		iRet = DEC_ClientStopView(iID,iChannel,iPos,iShowLastPic);
	}
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::Disconnect] Stop View Failed! Ret(%d),Error(0x%08x),ID(%d),Channel(%d),Pos(%d),ShowLastFrame(%d)"
			,iRet,GetLastError(),iID,iChannel,iPos,iShowLastPic);
	}

	return 0;
}

int CMainViewDlg::ModifyNvs( int _iItem,TNVSITEMEX& _tNvsItemEx )
{
	CNvsInfo dlgNvsInfo;
	int iID = GetCurrentID();
	if (iID < 0)
	{
		return -1;
	}

	int _iModify = _iItem < m_lstNvs.GetItemCount() ? 1 : 0; 
	dlgNvsInfo.Init(iID, &_tNvsItemEx, _iModify);
	if(dlgNvsInfo.DoModal() == IDOK)
	{
		ModifyNvsItem(_iItem,_tNvsItemEx);
	}

	return 0;
}

int CMainViewDlg::ModifyNvsEx(int _iItem, ViewServerInfo& _tNvsServer)
{
	CNvsInfo dlgNvsInfo;
	int iID = GetCurrentID();
	if (iID < 0)
	{
		return -1;
	}

	int _iModify = _iItem < m_lstNvs.GetItemCount() ? 1 : 0; 
	dlgNvsInfo.InitEx(iID, &_tNvsServer, _iModify);
	if(dlgNvsInfo.DoModal() == IDOK)
	{
		ModifyNvsServer(_iItem, _tNvsServer);
	}

	return 0;
}

int CMainViewDlg::DeleteNvs( int _iItem )
{
	int iID = GetCurrentID();
	if (iID < 0)
	{
		return -1;
	}
	int iChannel = GetCurrentChannel();
	int iPos = GetCurrentPos();
	int iRet = DEC_ClientGetLoopStatus(iID,iChannel,iPos);
	if (1 == iRet)
	{
		AddLog(LOG_LEVEL_WARN,"[CMainViewDlg::DeleteNvs] Looping!ID(%d),Channel(%d),Pos(%d)"
			,iID,iChannel,iPos);
		return -1;
	}

	iRet = DEC_ClientDelLoopItem(iID,_iItem,iChannel,iPos);
	if (ERR_SUCCESS == iRet)
	{
		m_lstNvs.DeleteItem(_iItem);
		AddLog(LOG_LEVEL_WARN,"[CMainViewDlg::DeleteNvs] Delete Loop Item Success!ID(%d),Channel(%d),Pos(%d),Item(%d)"
			,iID,iChannel,iPos,_iItem);
		
		int iCount = m_lstNvs.GetItemCount();
		if (_iItem >= iCount)
		{
			_iItem = iCount-1;
		}
		m_lstNvs.SetFocus();
		m_lstNvs.SetItemState(_iItem,LVIS_SELECTED,LVIS_SELECTED);
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::DeleteNvs] Delete Loop Item Failed!ID(%d),Channel(%d),Pos(%d),Item(%d)"
			,iID,iChannel,iPos,_iItem);
	}

	return 0;
}

void CMainViewDlg::OnBnClickedButtonAdd()
{
	int iItem = m_lstNvs.GetItemCount();
	//TNVSITEMEX tNvsItemEx = {0};
	//tNvsItemEx.m_iStructLen = sizeof(TNVSITEMEX);

	//tNvsItemEx.m_stOldItem.m_serNetmode = 1;
	//tNvsItemEx.m_stOldItem.m_serPort = 3000;
	//tNvsItemEx.m_stOldItem.m_iAddress = 1;
	//tNvsItemEx.m_stOldItem.m_holdtime = 20;
	//strcpy_s(tNvsItemEx.m_stOldItem.m_username,sizeof(tNvsItemEx.m_stOldItem.m_username),"Admin");
	//strcpy_s(tNvsItemEx.m_stOldItem.m_password,sizeof(tNvsItemEx.m_stOldItem.m_password),"1111");
	//strcpy_s(tNvsItemEx.m_cMultIP,sizeof(tNvsItemEx.m_cMultIP),"224.0.0.0");
	//tNvsItemEx.m_iMultPort = 20000;

	//ModifyNvs(iItem, tNvsItemEx);

	ViewServerInfo tViewServer = {0};
	tViewServer.ser_net_mode = 1;
	tViewServer.ser_port = 3000;
	tViewServer.ser_ptz_addr = 1;
	tViewServer.hold_time = 20;
	strcpy_s(tViewServer.ser_usr_name, sizeof(tViewServer.ser_usr_name), "Admin");
	strcpy_s(tViewServer.ser_usr_pwd, sizeof(tViewServer.ser_usr_pwd), "1111");
	strcpy_s(tViewServer.mult_ip, sizeof(tViewServer.mult_ip), "224.0.0.0");
	tViewServer.mult_port = 20000;
	ModifyNvsEx(iItem, tViewServer);
}

void CMainViewDlg::OnBnClickedButtonModify()
{
	POSITION pos = m_lstNvs.GetFirstSelectedItemPosition();
	if (pos)
	{
		int iItem = m_lstNvs.GetNextSelectedItem(pos);
		if (iItem >= 0)
		{
			LVITEM tItem = {0}; 
			tItem.iItem = iItem;
			tItem.mask = LVIF_IMAGE;
			m_lstNvs.GetItem(&tItem);
			if (STATE_OFFLINE == tItem.iImage)
			{
				//TNVSITEMEX tNvsItem = {0};
				//tNvsItem.m_iStructLen = sizeof(TNVSITEMEX);

				//GetNvsItem(iItem, tNvsItem);
				//ModifyNvs(iItem, tNvsItem);

				ViewServerInfo tViewServer = {0};
				GetNvsServer(iItem, tViewServer);
				ModifyNvsEx(iItem, tViewServer);
			}
		}
	}
}

void CMainViewDlg::OnBnClickedButtonDelete()
{
	POSITION pos = m_lstNvs.GetFirstSelectedItemPosition();
	if (pos)
	{
		int iItem = m_lstNvs.GetNextSelectedItem(pos);
		if (iItem >= 0)
		{
			LVITEM tItem = {0}; 
			tItem.iItem = iItem;
			tItem.mask = LVIF_IMAGE;
			m_lstNvs.GetItem(&tItem);
			if (STATE_OFFLINE == tItem.iImage)
			{
				if (0 == DeleteNvs(iItem))
				{
					//m_lstNvs.SetFocus();
					//m_lstNvs.SetItemState(iItem>0?(iItem-1):0, LVIS_SELECTED, LVIS_SELECTED);
				}
				
			}
		}
	}
}

void CMainViewDlg::OnBnClickedButtonConnect()
{
	POSITION pos = m_lstNvs.GetFirstSelectedItemPosition();
	if (pos)
	{
		int iItem = m_lstNvs.GetNextSelectedItem(pos);
		if (iItem >= 0)
		{
			LVITEM tItem = {0}; 
			tItem.iItem = iItem;
			tItem.mask = LVIF_IMAGE;
			m_lstNvs.GetItem(&tItem);
			if (STATE_OFFLINE == tItem.iImage)
			{
				Connect(iItem);
			}
		}
	}
}

void CMainViewDlg::OnBnClickedButtonDisconnect()
{
	POSITION pos = m_lstNvs.GetFirstSelectedItemPosition();
	if (pos)
	{
		int iItem = m_lstNvs.GetNextSelectedItem(pos);
		if (iItem >= 0)
		{
			// 			LVITEM tItem = {0}; 
			// 			tItem.iItem = iItem;
			// 			tItem.mask = LVIF_IMAGE;
			// 			m_lstNvs.GetItem(&tItem);
			// 			if (STATE_ONLINE == tItem.iImage)
			{
				Disconnect(iItem);
			}
		}
	}
}

int CMainViewDlg::UpdateChannelMode( int _iID,int _iChannel,int _iPicNum, int _iMode )
{
// 	if(_iChannel<0 || _iChannel>=(DEC_MAX_PHYSICAL_CHANNEL_NUM+DEC_MAX_SPLIT_CHANNEL_NUM))
// 	{
// 		return -1;
// 	}
	ChannelPicNum tPicNum = {0};
	tPicNum.iSize = sizeof(ChannelPicNum);
	tPicNum.iPicNum = _iPicNum;
	tPicNum.iMode = _iMode;
	int iRet = DEC_ClientSetDevConfig(_iID,_iChannel, 0, CMD_DEC_CFG_PICNUM, &tPicNum, tPicNum.iSize);
	if (ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::UpdateChannelMode] Set Channel Mode Failed! Ret(%d),Error(0x%08x),ID(%d),Channel(%d),Mode(%d)"
			,iRet,GetLastError(),_iID,_iChannel,_iMode);
	}

	return 0;
}

void CMainViewDlg::OnScreen1()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	UpdateChannelMode(iID,iChannel,1);
}

void CMainViewDlg::OnScreen2()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	UpdateChannelMode(iID,iChannel,2);
}

void CMainViewDlg::OnScreen4()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	UpdateChannelMode(iID,iChannel,4);
}

void CMainViewDlg::OnScreen0()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	UpdateChannelMode(iID,iChannel,0);
}
#define UDISK_STATUS_PLAYING 1
void CMainViewDlg::OnBnClickedButtonAudio()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	int iPos = GetCurrentPos();

	if (iID < 0)
	{
		AddLog(LOG_LEVEL_DEBUG, "iID < 0");
		return;
	}

	int iChannelConvert = ConvertChannel(iID, iChannel);
	int iPosConver = ConvertPos(iID, iPos);
	if (iChannelConvert < 0 || iPosConver < 0)
	{
		AddLog(LOG_LEVEL_DEBUG, "iChannelConvert < 0 || iPosConver < 0");
		return;
	}

	int iAudioStatus;
	int iCanOpen = 0;
	TNVSITEMEX nvs = {0};
	nvs.m_iStructLen = sizeof(TNVSITEMEX);

	if (DEC_ClientGetViewItemEx(iID, &nvs, iChannel, iPos) == 1)
	{
		iCanOpen = 1;
	}

	//жUǷڲ

	UDiskCurVideo tCurVideo = {0};
	int iRet = DEC_ClientGetDevConfig(iID,iChannel,\
		iPos,CMD_DEC_CFG_CURVIDEO,&tCurVideo,sizeof(UDiskCurVideo));
	if(ERR_SUCCESS == iRet)
	{
		if(UDISK_STATUS_PLAYING == tCurVideo.iCurVideoState)
		{
			iCanOpen = 1;
		}
	}else{
		AddLog(LOG_LEVEL_ERROR, "[CMainViewDlg::OnBnClickedButtonAudio] DEC_ClientGetDevConfig Failed! \
								Ret(%d),CMDID(CMD_DEC_CFG_CURVIDEO)",iRet);
	}

	st_Decoder *pDecoder = GetCurrentDecoder();
	if (NULL == pDecoder)
	{
		MessageBox(GetText(IDS_STRING_GET_DEC_FAIL), "",MB_OK|MB_TOPMOST);
		return;
	}

	st_PushStream& tPush = pDecoder->m_stPush[iChannelConvert][iPosConver];

	if(tPush.m_bStart)
	{
		iCanOpen = 1;
	}

	if(iCanOpen == 0)
	{
		MessageBox(GetText(IDS_MAIN_NOCONNECT),"",MB_OK|MB_TOPMOST);
		return;
	}

	CString szTemp;
	GetDlgItemText(IDC_BUTTON_AUDIO,szTemp);
	if (szTemp == GetText(IDS_MAIN_OPENAUDIO))
	{
		if (0 == tPush.m_iSpeed)
		{
			iAudioStatus = DEC_ClientSoundCtrl(iID,1,iChannel,iPos);  
			if (iAudioStatus ==0 )
			{
				tPush.m_bFlagAudio = true;
				SetDlgItemText(IDC_BUTTON_AUDIO, GetText(IDS_MAIN_CLOSEAUDIO));
			}
			else if (iAudioStatus == -12)   
			{
				MessageBox((LPCTSTR)GetText(IDS_MAIN_OPENAUDIOFAIL),"",MB_OK|MB_TOPMOST);
				return;
			}
		}	
	}
	else
	{
		if (DEC_ClientSoundCtrl(iID,0,iChannel,iPos)==0)
		{
			tPush.m_bFlagAudio = false;
			SetDlgItemText(IDC_BUTTON_AUDIO, GetText(IDS_MAIN_OPENAUDIO));
		}
		else
		{
			MessageBox(GetText(IDS_STRING_CLOSEAUDIO_FAIL),"",MB_OK|MB_TOPMOST);
		}
	}
}

void CMainViewDlg::OnBnClickedButtonTalk()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	int iPos = GetCurrentPos();

	TNVSITEMEX nvs = {0};
	nvs.m_iStructLen = sizeof(TNVSITEMEX);
	if (DEC_ClientGetViewItemEx(iID, &nvs, iChannel,iPos) != 1)
	{
		MessageBox(GetText(IDS_MAIN_NOCONNECT),"",MB_OK|MB_TOPMOST);
		return;
	}

	if (DEC_ClientGetLoopStatus(iID, iChannel, iPos))
	{
		return;
	}

	CString szTemp;
	GetDlgItemText(IDC_BUTTON_TALK,szTemp);
	if (szTemp == GetText(IDS_MAIN_STARTTALK))
	{
		int iRet = DEC_ClientTalkServer(iID, 1, iChannel, iPos);
		if(iRet == ERR_FORBID)
		{
			MessageBox(GetText(IDS_MAIN_TALKING),"",MB_OK|MB_TOPMOST);
		}
	}
	else
	{
		if (DEC_ClientTalkServer(iID,0,iChannel,iPos)==0)
		{
			SetDlgItemText(IDC_BUTTON_TALK,szTemp);
		}
	}    
}

void CMainViewDlg::OnNMDblclkListNvs(NMHDR *pNMHDR, LRESULT* /*pResult*/)
{
	LPNMITEMACTIVATE pItem = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	int iItem = pItem->iItem;
	if (iItem >= 0)
	{
		LVITEM tItem = {0}; 
		tItem.iItem = iItem;
		tItem.mask = LVIF_IMAGE;
		m_lstNvs.GetItem(&tItem);
		if (STATE_OFFLINE == tItem.iImage)
		{
			Connect(iItem);
		}
	}
}

void CMainViewDlg::OnBnClickedButtonAutoSwitch()
{
	int iID = GetCurrentID();
	if (iID < 0)
	{
		return;
	}
	int iChannel = GetCurrentChannel();
	int iPos = GetCurrentPos();

	int iChannelConvert = ConvertChannel(iID, iChannel);
	int iPosConver = ConvertPos(iID, iPos);
	if (iChannelConvert < 0 || iPosConver < 0)
	{
		return ;
	}

	st_Decoder* ptDecoder = GetCurrentDecoder();
	st_PushStream& tPush = ptDecoder->m_stPush[iChannelConvert][iPosConver];
	if(tPush.m_bStart)
	{
		return;
	}

	CString szTemp;
	GetDlgItemText(IDC_BUTTON_TALK,szTemp);
	if (szTemp == GetText(IDS_MAIN_STOPTALK))
	{
		MessageBox(GetText(IDS_MSG_AUTOSWITCH_DOWN), _T(""), MB_OK|MB_TOPMOST);
		return;
	}

	CString strSwitch;
	GetDlgItemText(IDC_BUTTON_AUTO_SWITCH,strSwitch);
	int iRet = 0;
	if (strSwitch.CompareNoCase(GetText(IDS_MAIN_AUTOSWITCH)) == 0)
	{
		if(m_lstNvs.GetItemCount() <= 0)
		{
			MessageBox(GetText(IDS_MAIN_NO_NVS),_T(""),MB_OK|MB_TOPMOST);
			return;
		}
		iRet = DEC_ClientStartLoop(iID,iChannel,iPos);
		if (ERR_SUCCESS == iRet)
		{  
			SetDlgItemText(IDC_BUTTON_AUTO_SWITCH,GetText(IDS_MAIN_STOPAUTOSWITCH));
			AddLog(LOG_LEVEL_DEBUG,"[CMainViewDlg::OnBnClickedButtonAutoSwitch] Start Loop Success!ID(%d),Channel(%d),Pos(%d)"
				,iID,iChannel,iPos);
		}
		else
		{
			AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::OnBnClickedButtonAutoSwitch] Start Loop Failed!Ret(%d),Error(0x%08x),ID(%d),Channel(%d),Pos(%d)"
				,iRet,GetLastError(),iID,iChannel,iPos);
		}
	}
	else
	{
		iRet = DEC_ClientStopLoop(iID,iChannel,iPos);
		if (ERR_SUCCESS == iRet)
		{  
			SetDlgItemText(IDC_BUTTON_AUTO_SWITCH,GetText(IDS_MAIN_AUTOSWITCH));
			AddLog(LOG_LEVEL_DEBUG,"[CMainViewDlg::OnBnClickedButtonAutoSwitch] Stop Loop Success!ID(%d),Channel(%d),Pos(%d)"
				,iID,iChannel,iPos);
		}
		else
		{
			AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::OnBnClickedButtonAutoSwitch] Stop Loop Failed!Ret(%d),Error(0x%08x),ID(%d),Channel(%d),Pos(%d)"
				,iRet,GetLastError(),iID,iChannel,iPos);
		}
	}
}

int CMainViewDlg::UpdateAudioStatus(int _iID,int _iChannel,int _iPos)
{
// 	if(_iChannel<0 || _iChannel>=(DEC_MAX_CHANNEL_NUM_NEW+DEC_MAX_VIRTUAL_CHANNEL_NUM))
// 	{
// 		return -1;
// 	}

	st_Decoder *pDecoder = GetCurrentDecoder();
	if (NULL == pDecoder)
	{
		return -1;
	}

	//ȡƵ״̬

	SoundCtrlResult tSoundCtrl = {0};
	int iRet = DEC_ClientRecvCommand(_iID,_iChannel,_iPos,DEC_COMMAND_SOUNDCTRL_RESULT,&tSoundCtrl,sizeof(SoundCtrlResult));
	if(iRet >= RET_SUCCESS)
	{
		if(AUDIO_STATUS_OPEN == tSoundCtrl.iAudioStatus)
		{
			SetDlgItemText(IDC_BUTTON_AUDIO, GetText(IDS_MAIN_CLOSEAUDIO));
		}
		else if(AUDIO_STATUS_CLOSE == tSoundCtrl.iAudioStatus)
		{
			SetDlgItemText(IDC_BUTTON_AUDIO, GetText(IDS_MAIN_OPENAUDIO));
		}else{
			//ʧܲд־
		}
		AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::UpdateAudioStatus] DEC_ClientRecvCommand[DEC_COMMAND_SOUNDCTRL_RESULT]Success!ID(%d),Channel(%d),Pos(%d),iAudioStatus(%d),iFailReason(%d)"
			,_iID,_iChannel,_iPos,tSoundCtrl.iAudioStatus,tSoundCtrl.iFailReason);

	}else{
		AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::UpdateAudioStatus]DEC_ClientRecvCommand[DEC_COMMAND_SOUNDCTRL_RESULT]Failed!Ret(%d),Error(0x%08x),ID(%d),Channel(%d),Pos(%d)"
			,iRet,GetLastError(),_iID,_iChannel,_iPos);
	}

	return 0;
}

int CMainViewDlg::UpdateTalkStatus(int _iID,int _iChannel,int _iPos)
{
// 	if(_iChannel<0 || _iChannel>=(DEC_MAX_CHANNEL_NUM_NEW+DEC_MAX_VIRTUAL_CHANNEL_NUM))
// 	{
// 		return -1;
// 	}

	//ȡԽ״̬
	TalkServResult tTalkServResult = {0};
	int iRet = DEC_ClientRecvCommand(_iID,_iChannel,_iPos,DEC_COMMAND_TALKSERVER_RESULT,&tTalkServResult,sizeof(TalkServResult));
	if(iRet >= RET_SUCCESS)
	{
		if(TALK_STATUS_CLOSE == tTalkServResult.iTalkStatus)
		{
			SetDlgItemText(IDC_BUTTON_TALK, GetText(IDS_MAIN_STARTTALK));
		}
		else if(TALK_STATUS_OPEN == tTalkServResult.iTalkStatus)
		{
			SetDlgItemText(IDC_BUTTON_TALK, GetText(IDS_MAIN_STOPTALK));
		}else{
			//ʧܲд־
		}
		AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::UpdateTalkStatus] DEC_ClientRecvCommand[DEC_COMMAND_TALKSERVER_RESULT]Success!ID(%d),Channel(%d),Pos(%d),iAudioStatus(%d),iFailReason(%d)"
			,_iID,_iChannel,_iPos,tTalkServResult.iTalkStatus,tTalkServResult.iFailReason);
	}else{
		AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::UpdateTalkStatus]DEC_ClientRecvCommand[DEC_COMMAND_TALKSERVER_RESULT]Failed!Ret(%d),Error(0x%08x),ID(%d),Channel(%d),Pos(%d)"
			,iRet,GetLastError(),_iID,_iChannel,_iPos);
	}

	return 0;
}

int CMainViewDlg::UpdateSwitchStatus(int _iID,int _iChannel,int _iPos)
{
	//add by sunhongwei(03324)
// 	if(_iChannel<0 || _iChannel>=(DEC_MAX_CHANNEL_NUM_NEW+DEC_MAX_VIRTUAL_CHANNEL_NUM))
// 	{
// 		return -1;
// 	}
	int iPic = 0;
	ChannelPicNum tPicNum = {0};
	tPicNum.iSize = sizeof(ChannelPicNum);

	int iRet = DEC_ClientGetDevConfig(_iID, _iChannel, 0, CMD_DEC_CFG_PICNUM, &tPicNum, sizeof(ChannelPicNum));
	if (ERR_SUCCESS == iRet)
	{
		iPic = tPicNum.iPicNum;
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR, "[CMainViewDlg::UpdateSwitchStatus] DEC_ClientGetDevConfig Failed! Ret(%d),CMDID(%d)",
			iRet, CMD_DEC_CFG_PICNUM);
	}

	int iSyncLoopStatus = 0;
	DecSyncLoopCtrl tLoopCtrl = {0};
	tLoopCtrl.iSize = sizeof(DecSyncLoopCtrl);
	iRet = DEC_ClientGetDevConfig(_iID, _iChannel, 0, CMD_DEC_CFG_SYNCLOOPCTRL, &tLoopCtrl, sizeof(DecSyncLoopCtrl));
	if (ERR_SUCCESS == iRet)
	{
		iSyncLoopStatus = tLoopCtrl.iLoopEnable;
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR, "[CMainViewDlg::UpdateSwitchStatus] DEC_ClientGetDevConfig Failed! Ret(%d),CMDID(%d)",
			iRet, CMD_DEC_CFG_SYNCLOOPCTRL);
	} 
	DecSyncLoopTime tLoopTime = {0};
	tLoopCtrl.iSize = sizeof(DecSyncLoopTime);
	iRet = DEC_ClientGetDevConfig(_iID, _iChannel, 0, CMD_DEC_CFG_SYNCLOOPTIME, &tLoopTime, sizeof(DecSyncLoopTime));
	if (ERR_SUCCESS == iRet)
	{
		SetDlgItemInt(IDC_EDIT_SYNC_LOOPTIME, tLoopTime.iHoldTime);
	}
	else
	{
		AddLog(LOG_LEVEL_ERROR, "[CMainViewDlg::UpdateSwitchStatus] DEC_ClientGetDevConfig Failed! Ret(%d),CMDID(%d)",
			iRet, CMD_DEC_CFG_SYNCLOOPTIME);
	}

	if ((_iID < 0 || iPic == 0)&& (_iPos < 0))
	{
		SetDlgItemText(IDC_BUTTON_AUTO_SWITCH, GetText(IDS_MAIN_AUTOSWITCH));
		GetDlgItem(IDC_BTN_SET_UP)->EnableWindow(FALSE);
		GetDlgItem(IDC_BTN_SET_DOWN)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_ADD)->EnableWindow(FALSE);
		GetDlgItem(IDC_CHECK_CFG)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_ADVANCE_ADD)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_MODIFY)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_DELETE)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_DELETE)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_AUTO_SWITCH)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_PUSH_STREAM)->EnableWindow(FALSE);
		GetDlgItem(IDC_CHECK_PUSH_PS_STREAM)->EnableWindow(FALSE);
		GetDlgItem(IDC_CHECK_LAST_FRAME)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_CONNECT)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_DISCONNECT)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_AUDIO)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_TALK)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_CTRL)->EnableWindow(FALSE);
		GetDlgItem(IDC_CHECK_ENCRYPTKEY)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_ENCRYPT)->EnableWindow(FALSE);
		GetDlgItem(IDC_STATIC_ENCRYPT)->EnableWindow(FALSE);

		GetDlgItem(IDC_BUTTON_FASTPLAY)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_SLOWPLAY)->EnableWindow(FALSE);
		GetDlgItem(IDC_COMBO_SIGNAL__PICTURE)->EnableWindow(FALSE);

		SetDlgItemText(IDC_BUTTON_SYNC_LOOPCTRL, GetText(IDS_MAIN_SYNCSWITCH));
		GetDlgItem(IDC_EDIT_SYNC_LOOPTIME)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_SYNC_LOOPCTRL)->EnableWindow(FALSE);

	}
	else if (1 == iSyncLoopStatus)
	{
		SetDlgItemText(IDC_BUTTON_AUTO_SWITCH, GetText(IDS_MAIN_AUTOSWITCH));
		GetDlgItem(IDC_BUTTON_ADD)->EnableWindow(FALSE);
		GetDlgItem(IDC_CHECK_CFG)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_ADVANCE_ADD)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_MODIFY)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_DELETE)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_DELETE)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_AUTO_SWITCH)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_PUSH_STREAM)->EnableWindow(TRUE);
		GetDlgItem(IDC_CHECK_PUSH_PS_STREAM)->EnableWindow(TRUE);
		GetDlgItem(IDC_CHECK_LAST_FRAME)->EnableWindow(TRUE);
		GetDlgItem(IDC_BTN_SET_UP)->EnableWindow(TRUE);
		GetDlgItem(IDC_BTN_SET_DOWN)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_CONNECT)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_DISCONNECT)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_AUDIO)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_TALK)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_CTRL)->EnableWindow(TRUE);
		GetDlgItem(IDC_CHECK_ENCRYPTKEY)->EnableWindow(TRUE);
		if(BST_UNCHECKED == m_chkEncryptKey.GetCheck())
		{
			GetDlgItem(IDC_EDIT_ENCRYPT)->EnableWindow(FALSE);
			GetDlgItem(IDC_STATIC_ENCRYPT)->EnableWindow(FALSE);
		}
		else if (BST_CHECKED == m_chkEncryptKey.GetCheck())
		{
			GetDlgItem(IDC_EDIT_ENCRYPT)->EnableWindow(TRUE);
			GetDlgItem(IDC_STATIC_ENCRYPT)->EnableWindow(TRUE);
		}
		GetDlgItem(IDC_BUTTON_FASTPLAY)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_SLOWPLAY)->EnableWindow(TRUE);
		GetDlgItem(IDC_COMBO_SIGNAL__PICTURE)->EnableWindow(TRUE);
		SetDlgItemText(IDC_BUTTON_SYNC_LOOPCTRL, GetText(IDS_MAIN_STOPAUTOSWITCH));
		GetDlgItem(IDC_BUTTON_SYNC_LOOPCTRL)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_SYNC_LOOPTIME)->EnableWindow(TRUE);
	}
	else if (1 == DEC_ClientGetLoopStatus(_iID,_iChannel,_iPos))
	{
		SetDlgItemText(IDC_BUTTON_AUTO_SWITCH, GetText(IDS_MAIN_STOPAUTOSWITCH));
		GetDlgItem(IDC_BUTTON_ADD)->EnableWindow(FALSE);
		GetDlgItem(IDC_CHECK_CFG)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_ADVANCE_ADD)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_MODIFY)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_DELETE)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_DELETE)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_AUTO_SWITCH)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_PUSH_STREAM)->EnableWindow(TRUE);
		GetDlgItem(IDC_CHECK_PUSH_PS_STREAM)->EnableWindow(TRUE);
		GetDlgItem(IDC_CHECK_LAST_FRAME)->EnableWindow(TRUE);
		GetDlgItem(IDC_BTN_SET_UP)->EnableWindow(TRUE);
		GetDlgItem(IDC_BTN_SET_DOWN)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_CONNECT)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_DISCONNECT)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_AUDIO)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_TALK)->EnableWindow(FALSE);
		GetDlgItem(IDC_BUTTON_CTRL)->EnableWindow(TRUE);

		GetDlgItem(IDC_CHECK_ENCRYPTKEY)->EnableWindow(TRUE);
		if(BST_UNCHECKED == m_chkEncryptKey.GetCheck())
		{
			GetDlgItem(IDC_EDIT_ENCRYPT)->EnableWindow(FALSE);
			GetDlgItem(IDC_STATIC_ENCRYPT)->EnableWindow(FALSE);
		}
		else if (BST_CHECKED == m_chkEncryptKey.GetCheck())
		{
			GetDlgItem(IDC_EDIT_ENCRYPT)->EnableWindow(TRUE);
			GetDlgItem(IDC_STATIC_ENCRYPT)->EnableWindow(TRUE);
		}

		GetDlgItem(IDC_BUTTON_FASTPLAY)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_SLOWPLAY)->EnableWindow(TRUE);
		GetDlgItem(IDC_COMBO_SIGNAL__PICTURE)->EnableWindow(TRUE);
		SetDlgItemText(IDC_BUTTON_SYNC_LOOPCTRL, GetText(IDS_MAIN_STOPAUTOSWITCH));
		GetDlgItem(IDC_BUTTON_SYNC_LOOPCTRL)->EnableWindow(FALSE);
		GetDlgItem(IDC_EDIT_SYNC_LOOPTIME)->EnableWindow(FALSE);
	}
	else
	{
		SetDlgItemText(IDC_BUTTON_AUTO_SWITCH, GetText(IDS_MAIN_AUTOSWITCH));
		GetDlgItem(IDC_BUTTON_ADD)->EnableWindow(TRUE);
		GetDlgItem(IDC_CHECK_CFG)->EnableWindow(TRUE);
		if (!m_bAddNVSing)
		{
			GetDlgItem(IDC_BUTTON_ADVANCE_ADD)->EnableWindow(TRUE);
		}
		GetDlgItem(IDC_BUTTON_MODIFY)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_DELETE)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_DELETE)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_AUTO_SWITCH)->EnableWindow(TRUE);
		GetDlgItem(IDC_BTN_SET_UP)->EnableWindow(TRUE);
		GetDlgItem(IDC_BTN_SET_DOWN)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_PUSH_STREAM)->EnableWindow(TRUE);
		GetDlgItem(IDC_CHECK_PUSH_PS_STREAM)->EnableWindow(TRUE);
		GetDlgItem(IDC_CHECK_LAST_FRAME)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_CONNECT)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_DISCONNECT)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_AUDIO)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_TALK)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_CTRL)->EnableWindow(TRUE);

		GetDlgItem(IDC_CHECK_ENCRYPTKEY)->EnableWindow(TRUE);
		if(BST_UNCHECKED == m_chkEncryptKey.GetCheck())
		{
			GetDlgItem(IDC_EDIT_ENCRYPT)->EnableWindow(FALSE);
			GetDlgItem(IDC_STATIC_ENCRYPT)->EnableWindow(FALSE);
		}
		else if (BST_CHECKED == m_chkEncryptKey.GetCheck())
		{
			GetDlgItem(IDC_EDIT_ENCRYPT)->EnableWindow(TRUE);
			GetDlgItem(IDC_STATIC_ENCRYPT)->EnableWindow(TRUE);
		}

		GetDlgItem(IDC_BUTTON_FASTPLAY)->EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_SLOWPLAY)->EnableWindow(TRUE);
		GetDlgItem(IDC_COMBO_SIGNAL__PICTURE)->EnableWindow(TRUE);
		SetDlgItemText(IDC_BUTTON_SYNC_LOOPCTRL, GetText(IDS_MAIN_SYNCSWITCH));
		GetDlgItem(IDC_BUTTON_SYNC_LOOPCTRL)->EnableWindow(TRUE);
		GetDlgItem(IDC_EDIT_SYNC_LOOPTIME)->EnableWindow(TRUE);
	}

	return 0;
}

static int GetLocalFileType(CString strFullPath)
{	
	if (-1 != strFullPath.Find(_T(".mp4")))
	{
		return LOCAL_FILETYPE_MP4;
	}
	else
	{
		return LOCAL_FILETYPE_SDV;
	}
}

void CMainViewDlg::InnerPush()
{
	int iID = GetCurrentID();
	if (iID < 0)
	{
		return;
	}

	st_Decoder* ptDecoder = GetCurrentDecoder();
	if (ptDecoder == NULL)
	{
		return;
	}

	int iChannel = GetCurrentChannel();
	int iPos  =  GetCurrentPos();
	int iShowLastPic = m_chkLastFrame.GetCheck();

	int iChannelConvert = ConvertChannel(iID, iChannel);
	int iPosConver = ConvertPos(iID, iPos);
	if (iChannelConvert < 0 || iPosConver < 0)
	{
		return;
	}

	st_PushStream& tStream = ptDecoder->m_stPush[iChannelConvert][iPosConver];

	START_PUSH_PARAM strStartPushParam = {0};
	strStartPushParam.m_iSize = sizeof(START_PUSH_PARAM);
	if (tStream.m_lPushID != -1)//stop
	{
		InnerStopPush(&tStream);

		GetDlgItem(IDC_BUTTON_FASTPLAY)->SetWindowText(GetText(IDS_MAINDLG_FASTPLAY));
		GetDlgItem(IDC_BUTTON_SLOWPLAY)->SetWindowText(GetText(IDS_MAINDLG_SLOWPLAY));
		CString strTemp;
		GetDlgItemText(IDC_BUTTON_AUDIO,strTemp);
		if (strTemp == GetText(IDS_MAIN_CLOSEAUDIO))
		{
			SetDlgItemText(IDC_BUTTON_AUDIO, GetText(IDS_MAIN_OPENAUDIO));
		}
		if(iID >= 0 && 1 == DEC_ClientGetAudioStatus(iID,iChannel,iPos))
		{
			//Ƶ
			if (DEC_ClientSoundCtrl(iID,0,iChannel,iPos)==0)
			{
				AddLog(LOG_LEVEL_DEBUG,"[CMainViewDlg::OnBnClickedButtonFastplay] Close audio Success! iID(%d)",iID);
			}
			SetDlgItemText(IDC_BUTTON_AUDIO, GetText(IDS_MAIN_OPENAUDIO));
		}

		AddLog(LOG_LEVEL_DEBUG,"[CMainViewDlg::OnBnClickedButtonPushStream] Stop Push Stream Success! PushID(%d)"
			,tStream.m_lPushID);

	}
	else//start
	{   
		CFileDialog dlgOpenFile(TRUE, NULL, NULL
			, OFN_FILEMUSTEXIST | OFN_HIDEREADONLY | OFN_ENABLESIZING
			, _T("sdv files(*.sdv)|*.sdv|dat files(*.dat)|*.dat|dat files(*.mp4)|*.mp4|all files(*.*)|*.*|"));
		if(IDOK == dlgOpenFile.DoModal())
		{
			CString strFile = dlgOpenFile.GetPathName();

			tStream.m_iSpeed = 0; //StartPushٶ
			GetDlgItem(IDC_BUTTON_FASTPLAY)->SetWindowText(GetText(IDS_MAINDLG_FASTPLAY));
			GetDlgItem(IDC_BUTTON_SLOWPLAY)->SetWindowText(GetText(IDS_MAINDLG_SLOWPLAY));

			if (tStream.m_pFile != NULL)
			{
				delete tStream.m_pFile;
				tStream.m_pFile = NULL;
			}

			long lRet = -1;
			if (BST_CHECKED == m_chkPsStream.GetCheck())
			{
				tStream.m_pFile = new CLS_PsFileReader(strFile);
				lRet = DEC_ClientStartPushStream(iID, iChannel, iPos, ENCODE_PS, VIDEO_FD1);
				if(lRet >= 0)
				{
					tStream.m_lPushID = lRet;
					AddLog(LOG_LEVEL_DEBUG,"[CMainViewDlg::OnBnClickedButtonPushStream] Start Push Ps Stream Success! PushID(%d),ID(%d),Channel(%d),Pos(%d)======ptDecoder->m_stPush[%d][%d].m_lPushID(%d)"
						,lRet,iID, iChannel, iPos,iChannel, iPos,tStream.m_lPushID);
				}
				else
				{
					AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::OnBnClickedButtonPushStream] Start Push Ps Stream Failed! Ret(%d),Error(0x%08x),ID(%d),Channel(%d),Pos(%d)"
						,lRet,GetLastError(),iID, iChannel, iPos);
				}
			}
			else
			{
				td_bool bIsMp4 = CLS_MP4Operation::Instance()->MP4_IsMP4Format((td_char*)(LPCSTR)(LPCTSTR)strFile);
				if (bIsMp4)
				{
					tStream.m_pFile = new CLS_MP4FileReader(strFile);
				}
				else
				{
					tStream.m_pFile = new CLS_SdvFileReader(strFile);
				}

				S_header fileHeader = {0};

				int iRead = tStream.m_pFile->ReadFileHeader(&fileHeader);
				if (iRead < 0)
				{
					AddLog(LOG_LEVEL_DEBUG,"iRead header< 0");
					return ;
				}

				CString strEncryptKey;
				char cEncryptKey[17] = {0};
				GetDlgItem(IDC_EDIT_ENCRYPT)->GetWindowText(strEncryptKey);
				strcpy_s(cEncryptKey, MAX_ENCRYPT_KEY,strEncryptKey);
				strcpy_s(strStartPushParam.m_cEncryptKey, MAX_ENCRYPT_KEY, cEncryptKey);
				memcpy(strStartPushParam.m_cFileHeader,&fileHeader,VIDEO_HEADER_SIZE);
				lRet = DEC_ClientStartPushStream_V1(iID, iChannel, iPos, &strStartPushParam);
				int iCmdValue = PUSH_PLAYBACK_STREAM_PLAY;
				if(lRet >= 0)
				{
					DEC_ClientStreamControl(lRet, PUSH_STREAM_CMD_PAUSE, &iCmdValue, sizeof(int));	//ҪȻƵ
					tStream.m_lPushID = lRet;
					AddLog(LOG_LEVEL_DEBUG,"[CMainViewDlg::OnBnClickedButtonPushStream] Start Push Stream Success! PushID(%d),ID(%d),Channel(%d),Pos(%d)======ptDecoder->m_stPush[%d][%d].m_lPushID(%d)"
						,lRet,iID, iChannel, iPos,iChannel, iPos,tStream.m_lPushID);
				}
				else
				{
					AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::OnBnClickedButtonPushStream] Start Push Stream Failed! Ret(%d),Error(0x%08x),ID(%d),Channel(%d),Pos(%d)"
						,lRet,GetLastError(),iID, iChannel, iPos);
				}
			}
		}
	}
}

void CMainViewDlg::OnBnClickedButtonPushStream()
{
	InnerPush();
}

void CMainViewDlg::OnTimer(UINT_PTR nIDEvent)
{
	CDialog::OnTimer(nIDEvent);
}

void CMainViewDlg::OnDestroy()
{
	KillTimer(TIMER_PUSH_STREAM);
	SaveDecoderList();

	if (m_pDlgSearchNVS)
	{
		m_pDlgSearchNVS->DestroyWindow();
		delete m_pDlgSearchNVS;
		m_pDlgSearchNVS = NULL;
	}

	StopPushStream();
	int iShowLastPic = m_chkLastFrame.GetCheck();
	for(unsigned int i=0;i<m_VecDecoder.size();++i)
	{
		st_Decoder* pDecoder = (st_Decoder*)m_VecDecoder[i];
		if (NULL ==  pDecoder)
		{
			AddLog(LOG_LEVEL_DEBUG,"NULL ==  pDecoder");
			continue;
		}

		for(int j=0; j<(DEC_MAX_CHANNEL_TOTAL_NUM); ++j)
		{
			for(int k=0; k<DEC_MAX_WINDOW_TOTAL_NUM; ++k)
			{
				st_PushStream& tPush = pDecoder->m_stPush[j][k];
				if(tPush.m_bStart == 1)
				{
					InnerStopPush(&tPush);
				}
			}
		}

		DEC_ClientLogout(pDecoder->m_lID);
		pDecoder->m_lID = -1;
	}


	if(NetAdmin_Closeup)
	{
		NetAdmin_Closeup();
	}

	__try
	{
		if (DEC_ClientCleanup)
		{
			DEC_ClientCleanup();
		}
	}
	__except(1)
	{
		
	}

	CLS_NetAdmin_Interface::FreeDLL();
	//CLS_NVDSDK_Interface::FreeDLL();

	CDialog::OnDestroy();
}

void CMainViewDlg::OnBnClickedButtonIntelligentAdd()
{
	int iID = GetCurrentID();
	if (iID < 0)
	{
		return ;
	}

	if (NULL == m_pDlgSearchNVS)
	{
		m_pDlgSearchNVS = new CSearchNVS(this);
		if (m_pDlgSearchNVS)
		{
			m_pDlgSearchNVS->Create(IDD_DIALOG_SEARCHNVS, this);
		}
		else
			return;
	}

	m_pDlgSearchNVS->Init(iID, this);
	m_pDlgSearchNVS->ShowWindow(SW_NORMAL);
}

void CMainViewDlg::SaveDecoderList()
{
	try
	{
		CString strPath;   
		GetModuleFileName(NULL, strPath.GetBuffer(MAX_PATH), MAX_PATH);   
		strPath.ReleaseBuffer();   
		strPath = strPath.Left(strPath.ReverseFind(_T('\\')));   
		strPath += "\\decoder.ini";
		if (g_strInstDir != "")
		{
			strPath = g_strInstDir + _T("decoder.ini");
		}
		CIniFile ini(strPath);
		DeleteFile(strPath);                                       //ɾļ
		int iCount = 0;
		for (size_t i=0;i<m_VecDecoder.size();++i)
		{

			st_Decoder* pDecoder = (st_Decoder*)m_VecDecoder[i];
			if (NULL ==  pDecoder)
			{
				AddLog(LOG_LEVEL_DEBUG,"NULL ==  pDecoder");
				continue;
			}
		
			if (strlen(pDecoder->m_cIP) != 0 && pDecoder->m_iPort != -1)
			{
				iCount++;
				CString szSec;
				szSec.Format("dec%d",iCount);
				ini.WriteString(szSec, "ip", pDecoder->m_cIP);
				CString szTemp;
				szTemp.Format("%d", pDecoder->m_iPort);
				ini.WriteString(szSec, "port", szTemp);
				szTemp.Format("%d", pDecoder->m_bStayPass);
				ini.WriteString(szSec,"stay",szTemp);
				if(pDecoder->m_bStayPass)
				{
					ini.WriteString(szSec,"user", pDecoder->m_astrUser);
					char base64[512];
					EncodeBase64(base64, (LPSTR)(LPCTSTR)pDecoder->m_astrPass);
					ini.WriteString(szSec,"password",base64);
				}
			}
		}
		CString szCount;
		szCount.Format("%d", iCount);
		ini.WriteString("decoder","count",szCount);
	}
	catch (...)
	{
		AddLog(LOG_LEVEL_ERROR,"[USER] Save decoder list failed!");
	}
}

void CMainViewDlg::LoadDecoderList()
{
	m_tvDecoder.DeleteAllItems();
	CString strPath;   
	GetModuleFileName(NULL, strPath.GetBuffer(MAX_PATH), MAX_PATH);   
	strPath.ReleaseBuffer();   
	strPath = strPath.Left(strPath.ReverseFind(_T('\\')));   
	strPath += "\\decoder.ini";
	if (g_strInstDir != "")
	{
		strPath = g_strInstDir + _T("decoder.ini");
	}
	CIniFile ini(strPath);
	int iCount = ini.ReadInteger("decoder","count",0);
	for (int i=0;i<iCount;i++)
	{
		CString szSec;
		szSec.Format("dec%d",i+1);
		CString szIP = ini.ReadString(szSec,"ip","");
		int iPort = ini.ReadInteger(szSec,"port",3000);
		int iStay = ini.ReadInteger(szSec,"stay",0);
		CString szUser, szPass;
		if(iStay)
		{
			szUser = ini.ReadString(szSec,"user","Admin");
			szPass = ini.ReadString(szSec,"password","1111");
			if(szPass != "1111")
			{
				char base64[512];
				DecodeBase64(base64, (LPSTR)(LPCTSTR)szPass);
				szPass = CString(base64);
			}
		}
		if (szIP=="")
			continue;

		st_Decoder temp;
		strcpy_s(temp.m_cIP,sizeof(temp.m_cIP), (LPSTR)(LPCTSTR)szIP);
		temp.m_iPort = iPort;
		temp.m_bStayPass = iStay;
		if(iStay)
		{
			temp.m_astrUser = szUser;
			temp.m_astrPass = szPass;
		}
		AddDecoder(&temp);
	}
}

void CMainViewDlg::OnScreen3()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	UpdateChannelMode(iID,iChannel, 3);
}

void CMainViewDlg::OnScreen6()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	UpdateChannelMode(iID,iChannel, 6);
}

void CMainViewDlg::OnScreen8()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	UpdateChannelMode(iID,iChannel, 8);
}

void CMainViewDlg::OnScreen9()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	UpdateChannelMode(iID,iChannel, 9);
}

void CMainViewDlg::OnScreen16()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	UpdateChannelMode(iID,iChannel, 16);
}

void CMainViewDlg::OnScreen10()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	UpdateChannelMode(iID,iChannel, 10);
}

void CMainViewDlg::OnScreen13()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	UpdateChannelMode(iID,iChannel, 13);
}

void CMainViewDlg::OnScreen20A()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	UpdateChannelMode(iID,iChannel, 20);
}

void CMainViewDlg::OnScreen20B()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	UpdateChannelMode(iID,iChannel, 20, 1);
}

void CMainViewDlg::OnScreen25()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	UpdateChannelMode(iID,iChannel, 25);
}

void CMainViewDlg::OnScreen36()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	UpdateChannelMode(iID,iChannel, 36);
}

void CMainViewDlg::OnScreen40()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	UpdateChannelMode(iID,iChannel, 40);
}

void CMainViewDlg::OnScreen64()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	UpdateChannelMode(iID,iChannel, 64);
}

void CMainViewDlg::OnScreen100()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	UpdateChannelMode(iID,iChannel, 100);
}

int CMainViewDlg::ModifyNvsItem(int _iItem,TNVSITEMEX& _tNvsItemEx )
{
	int iID = GetCurrentID();
	if (iID < 0)
	{
		return -1;
	}

	int iChannel = GetCurrentChannel();
	int iPos = GetCurrentPos();
	{
		if (_iItem < 0)
		{
			_iItem = m_lstNvs.GetItemCount();
		}

		ServerItem tServerItem = {0};
		int iType = _tNvsItemEx.m_iDevPlatType;//TODO
		ConvertItem(tServerItem, &_tNvsItemEx);


		int iRet = DEC_ClientSetLoopItem_V1(iID, iChannel, iPos, _iItem, iType, &tServerItem);//-------->>õǰѭлбеNVS


		if(ERR_SUCCESS == iRet)
		{
			ServerItem tServerItem = {0};
			int iType = _tNvsItemEx.m_iDevPlatType;//TODO
			ConvertItem(tServerItem, &_tNvsItemEx);

			UpdateNVSItem(_iItem, iType, tServerItem);
		}
		else if(iRet == ERR_INVALIDPARA)//Ƿ---------------->>
		{
			MessageBox(GetText(IDS_NVS_INFO_INVALID_PARAM),_T(""),MB_OK|MB_TOPMOST); 
		}
		else if (iRet == ERR_FORBID)//
		{
			MessageBox(GetText(IDS_NVS_INFO_OPERATION_FORBIDDED),_T(""),MB_OK|MB_TOPMOST);
		}
		else if (iRet == ERR_RELOOPITEM)//ѭбظ
		{
			MessageBox(GetText(IDS_NVS_INFO_RELOOP_ITEM),_T(""),MB_OK|MB_TOPMOST);
		}
	}

	return 0;
}

int CMainViewDlg::ModifyNvsServer(int _iItem, ViewServerInfo& _tNvsServer)
{
	int iID = GetCurrentID();
	if (iID < 0)
	{
		return -1;
	}

	int iChannel = GetCurrentChannel();
	int iPos = GetCurrentPos();
	{
		if (_iItem < 0)
		{
			_iItem = m_lstNvs.GetItemCount();
		}

		ServerItem tServerItem = {0};
		int iType = 0;
		ConvertSeverToItem(&_tNvsServer, &tServerItem, &iType);
		int iRet = DEC_ClientSetLoopItem_V1(iID, iChannel, iPos, _iItem, iType, &tServerItem);//-------->>õǰѭлбеNVS
		if(ERR_SUCCESS == iRet)
		{
			UpdateNvsServer(_iItem, _tNvsServer);
		}
		else if(iRet == ERR_INVALIDPARA)//Ƿ---------------->>
		{
			MessageBox(GetText(IDS_NVS_INFO_INVALID_PARAM),_T(""),MB_OK|MB_TOPMOST); 
		}
		else if (iRet == ERR_FORBID)//
		{
			MessageBox(GetText(IDS_NVS_INFO_OPERATION_FORBIDDED),_T(""),MB_OK|MB_TOPMOST);
		}
		else if (iRet == ERR_RELOOPITEM)//ѭбظ
		{
			MessageBox(GetText(IDS_NVS_INFO_RELOOP_ITEM),_T(""),MB_OK|MB_TOPMOST);
		}
	}

	return 0;
}

int CMainViewDlg::InitDecoder( int _iFlag, void* _pvValue )
{
	if (NULL == _pvValue)
		return -1;

	switch (_iFlag)
	{
	case 0x00000001:
		m_iIsOCX = *(int*)_pvValue;
		break;
	default:
		break;
	}

	return 0;
}

LRESULT CMainViewDlg::OnAddNVSMsg( WPARAM _wParam,LPARAM _lParam )
{
	if (0 == _wParam)
	{
		m_bAddNVSing = false;
		m_cboPos.EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_ADVANCE_ADD)->EnableWindow(TRUE);
	}
	else
	{
		m_bAddNVSing = true;
		m_cboPos.EnableWindow(TRUE);
		GetDlgItem(IDC_BUTTON_ADVANCE_ADD)->EnableWindow(FALSE);
	}

	return S_OK;
}

void CMainViewDlg::OnBnClickedCheckEncryptkey()
{
	// TODO: Add your control notification handler code here
	if(BST_UNCHECKED == m_chkEncryptKey.GetCheck())
	{
		GetDlgItem(IDC_EDIT_ENCRYPT)->EnableWindow(FALSE);
		GetDlgItem(IDC_STATIC_ENCRYPT)->EnableWindow(FALSE);
	}
	else if (BST_CHECKED == m_chkEncryptKey.GetCheck())
	{
		GetDlgItem(IDC_EDIT_ENCRYPT)->EnableWindow(TRUE);
		GetDlgItem(IDC_STATIC_ENCRYPT)->EnableWindow(TRUE);
	}

}

void CMainViewDlg::OnBnClickedButtonFastplay()
{
	// TODO: Add your control notification handler code here
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	int iPos = GetCurrentPos();
	int iChannelConvert = ConvertChannel(iID, iChannel);
	int iPosConver = ConvertPos(iID, iPos);
	if (iChannelConvert < 0 || iPosConver < 0)
	{
		return;
	}
	st_Decoder *pDecoder = GetCurrentDecoder();
	if (NULL == pDecoder)
	{
		return;
	}

	st_PushStream& tPush = pDecoder->m_stPush[iChannelConvert][iPosConver];

	if (true == tPush.m_bFlagAudio)
	{
		//Ƶ
		if (DEC_ClientSoundCtrl(iID,0,iChannel,iPos)==0)
		{
			AddLog(LOG_LEVEL_DEBUG,"[CMainViewDlg::OnBnClickedButtonFastplay] Close audio Success! iID(%d)",iID);
		}
		SetDlgItemText(IDC_BUTTON_AUDIO, GetText(IDS_MAIN_OPENAUDIO));
	}

	GetDlgItem(IDC_BUTTON_SLOWPLAY)->SetWindowText(GetText(IDS_MAINDLG_SLOWPLAY));
	tPush.m_iSpeed++;
	if (tPush.m_iSpeed <= 0)
	{
		tPush.m_iSpeed = 1;
	}

	if (1 == tPush.m_iSpeed)
	{
		GetDlgItem(IDC_BUTTON_FASTPLAY)->SetWindowText(GetText(IDS_MAINDILG_FASTPLAYx2));
	}

	if (2 == tPush.m_iSpeed)
	{
		GetDlgItem(IDC_BUTTON_FASTPLAY)->SetWindowText(GetText(IDS_MAINDLG_FASTPLAYx4));
	}

	if (3 == tPush.m_iSpeed)
	{
		GetDlgItem(IDC_BUTTON_FASTPLAY)->SetWindowText(GetText(IDS_MAINDLG_FASTPLAYx8));
	}

	if (4 == tPush.m_iSpeed)
	{
		GetDlgItem(IDC_BUTTON_FASTPLAY)->SetWindowText(GetText(IDS_MAINDLG_FASTPLAYx16));
	}

	if (tPush.m_iSpeed > 4)
	{
		GetDlgItem(IDC_BUTTON_FASTPLAY)->SetWindowText(GetText(IDS_MAINDLG_FASTPLAY));
		tPush.m_iSpeed = 0;
	}

	int iRet = DEC_ClientStreamControl(tPush.m_lPushID,PUSH_STREAM_CMD_FAST, &tPush.m_iSpeed,sizeof(int));
	if (iRet != 0)
	{
		AddLog(LOG_LEVEL_DEBUG,"[FastPushSpeed]fail!Return value(%d)\n",iRet);
	}

	if (0 == tPush.m_iSpeed)
	{
		if (true == tPush.m_bFlagAudio)
		{
			//Ƶ
			if (DEC_ClientSoundCtrl(iID,1,iChannel,iPos)==0)
			{
				AddLog(LOG_LEVEL_DEBUG,"[CMainViewDlg::OnBnClickedButtonFastplay] Open audio Success! iID(%d)",iID);
			}
			SetDlgItemText(IDC_BUTTON_AUDIO, GetText(IDS_MAIN_CLOSEAUDIO));

			DEC_ClientConfigStreamInfo(iID, iChannel, iPos,CONF_CMD_AUDIOVIDEO, NULL, 0);//ʵƵͬ
		}
	}
	
}

void CMainViewDlg::OnBnClickedButtonSlowplay()
{
	// TODO: Add your control notification handler code here
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	int iPos = GetCurrentPos();
	int iChannelConvert = ConvertChannel(iID, iChannel);
	int iPosConver = ConvertPos(iID, iPos);
	if (iChannelConvert < 0 || iPosConver < 0)
	{
		return;
	}
	st_Decoder *pDecoder = GetCurrentDecoder();
	if (NULL == pDecoder)
	{
		return;
	}

	st_PushStream& tPush = pDecoder->m_stPush[iChannelConvert][iPosConver];
	if (true == tPush.m_bFlagAudio)
	{
		if (DEC_ClientSoundCtrl(iID,0,iChannel,iPos)==0)
		{
			AddLog(LOG_LEVEL_DEBUG,"[CMainViewDlg::OnBnClickedButtonSlowplay] Close audio Success! iID(%d)",iID);
		}
		SetDlgItemText(IDC_BUTTON_AUDIO, GetText(IDS_MAIN_OPENAUDIO));
	}

	GetDlgItem(IDC_BUTTON_FASTPLAY)->SetWindowText(GetText(IDS_MAINDLG_FASTPLAY));
	tPush.m_iSpeed--;
	if (tPush.m_iSpeed >= 0)
	{
		tPush.m_iSpeed = -1;
	}

	if (-1 == tPush.m_iSpeed)
	{
		GetDlgItem(IDC_BUTTON_SLOWPLAY)->SetWindowText(GetText(IDS_MAINDLG_SLOWPLAYx2));
	}

	if (-2 == tPush.m_iSpeed)
	{
		GetDlgItem(IDC_BUTTON_SLOWPLAY)->SetWindowText(GetText(IDS_MAINDLG_SLOWPLAYx4));
	}

	if (-3 == tPush.m_iSpeed)
	{
		GetDlgItem(IDC_BUTTON_SLOWPLAY)->SetWindowText(GetText(IDS_MAINDLG_SLOWPLAYx8));
	}

	if (-4 == tPush.m_iSpeed)
	{
		GetDlgItem(IDC_BUTTON_SLOWPLAY)->SetWindowText(GetText(IDS_MAINDLG_SLOWPLAYx16));
	}

	if (tPush.m_iSpeed < -4)
	{
		GetDlgItem(IDC_BUTTON_SLOWPLAY)->SetWindowText(GetText(IDS_MAINDLG_SLOWPLAY));
		tPush.m_iSpeed = 0;
	}

	int iSpeed = abs(tPush.m_iSpeed);

	int iRet = DEC_ClientStreamControl(tPush.m_lPushID,PUSH_STREAM_CMD_SLOW, &iSpeed,sizeof(int));
	if (iRet != 0)
	{
		AddLog(LOG_LEVEL_DEBUG,"[DEC_ClientSetSlowPushSpeed]fail!Return value(%d)\n",iRet);
	}

	if (0 == tPush.m_iSpeed)
	{
		if (true == tPush.m_bFlagAudio)
		{
			if (DEC_ClientSoundCtrl(iID,1,iChannel,iPos)==0)
			{
				AddLog(LOG_LEVEL_DEBUG,"[CMainViewDlg::OnBnClickedButtonFastplay] Open audio Success! iID(%d)",iID);
			}
			SetDlgItemText(IDC_BUTTON_AUDIO, GetText(IDS_MAIN_CLOSEAUDIO));
		}
	}

}

int CMainViewDlg::UpdatePushStreamAudioStatus(int _iID,int _iChannel,int _iPos)
{
	if (_iID < 0)
	{
		return -1;
	}

// 	if(_iChannel<0 || _iChannel>=(DEC_MAX_CHANNEL_NUM_NEW+DEC_MAX_VIRTUAL_CHANNEL_NUM))
// 	{
// 		return -1;
// 	}

	GetDlgItem(IDC_BUTTON_FASTPLAY)->SetWindowText(GetText(IDS_MAINDLG_FASTPLAY));
	GetDlgItem(IDC_BUTTON_SLOWPLAY)->SetWindowText(GetText(IDS_MAINDLG_SLOWPLAY));

	st_Decoder *pDecoder = GetCurrentDecoder();
	if (NULL == pDecoder)
	{
		return -1;
	}

	CString strFastState[] = {GetText(IDS_MAINDLG_FASTPLAY), GetText(IDS_MAINDILG_FASTPLAYx2), GetText(IDS_MAINDLG_FASTPLAYx4), 
	GetText(IDS_MAINDLG_FASTPLAYx8), GetText(IDS_MAINDLG_FASTPLAYx16)};
	int iChannel = ConvertChannel(pDecoder->m_lID, _iChannel);
	int iPos = ConvertPos(pDecoder->m_lID, _iPos);
	if (iChannel < 0 || iPos < 0)
	{
		return -1;
	}
	st_PushStream& tPush = pDecoder->m_stPush[iChannel][iPos];
	int iSpeed = tPush.m_iSpeed;
	if (iSpeed >=0 && iSpeed < sizeof(strFastState)/sizeof(CString))
	{
		GetDlgItem(IDC_BUTTON_FASTPLAY)->SetWindowText(strFastState[iSpeed]);
	}
	// ָٶ
	if (tPush.m_iSpeed > 4)
	{
		GetDlgItem(IDC_BUTTON_FASTPLAY)->SetWindowText(GetText(IDS_MAINDLG_FASTPLAY));
		tPush.m_iSpeed = 0;
	}

	if (-1 == tPush.m_iSpeed)
	{
		GetDlgItem(IDC_BUTTON_SLOWPLAY)->SetWindowText(GetText(IDS_MAINDLG_SLOWPLAYx2));
	}

	if (-2 == tPush.m_iSpeed)
	{
		GetDlgItem(IDC_BUTTON_SLOWPLAY)->SetWindowText(GetText(IDS_MAINDLG_SLOWPLAYx4));
	}

	if (-3 ==tPush.m_iSpeed)
	{
		GetDlgItem(IDC_BUTTON_SLOWPLAY)->SetWindowText(GetText(IDS_MAINDLG_SLOWPLAYx8));
	}

	if (-4 == tPush.m_iSpeed)
	{
		GetDlgItem(IDC_BUTTON_SLOWPLAY)->SetWindowText(GetText(IDS_MAINDLG_SLOWPLAYx16));
	}

	if (tPush.m_iSpeed < -4)
	{
		GetDlgItem(IDC_BUTTON_SLOWPLAY)->SetWindowText(GetText(IDS_MAINDLG_SLOWPLAY));
		tPush.m_iSpeed = 0;
	}

	return 0;
}

void CMainViewDlg::UpdatePosNum(int iLogonId, int iChannel)
{
	if(iLogonId < 0)
		return;
	else
		m_cboPos.SetCurSel(0);

}

int CMainViewDlg::PushFile(st_PushStream*  tPush)
{
	if (tPush == NULL)
	{
		AddLog(LOG_LEVEL_DEBUG, "tPush == NULL");
		return -1;
	}

	if(!tPush->m_bStart)
	{
		return 0;
	}

	CLS_FileReader* pFile = tPush->m_pFile;
	long lPushID = tPush->m_lPushID;
	if(pFile == NULL)
	{
		return 0;
	}

	int iTime = 0;

	while(1)
	{
		iTime++;
		if (iTime > MAX_SEND_TIMES)
		{
			return 0;
		}
		int iBufState = 0;
		int iRet = DEC_ClientGetStreamBufferState(lPushID, &iBufState);
		if (iRet < 0)
		{
			return -1;
		}
		if((RET_BUFFER_FULL == iBufState) || (RET_BUFFER_WILL_BE_FULL == iBufState))
		{
			return -1;
		}
#ifdef TEST_RAW_STREAM
		S_FrameHeader frameHeader = {0};
		iRet = pFile->ReadFrame((char*)&frameHeader, sizeof(frameHeader));
		int iFrameLen = frameHeader.u32FrameSize - sizeof(frameHeader);
		iRet = pFile->ReadFrame(s_cPushBuffer, iFrameLen);
		int iPushReturn = 0;

		int itime = 0;
		iPushReturn = DEC_ClientSendRawFrame(lPushID, iRet, s_cPushBuffer);
		if (iPushReturn != RET_BUFFER_FULL)
		{
			//break;
		}
		else
		{
			AddLog(LOG_LEVEL_DEBUG,"[CLS_DlgSettingOSD::updatedialog] %d", itime++);
		}

		Sleep(36);
#else
		iRet = pFile->ReadFrame(s_cPushBuffer, MAX_FRAME_SIZE);
		int iPushReturn = 0;

		int itime = 0;
		iPushReturn = DEC_ClientSendStream(lPushID, iRet, s_cPushBuffer);
		if (iPushReturn != RET_BUFFER_FULL)
		{
			//break;
		}
		else
		{
			AddLog(LOG_LEVEL_DEBUG,"[CLS_DlgSettingOSD::updatedialog] %d", itime++);
		}
#endif	
	}
	return 0;
}

int CMainViewDlg::PushStreamData()
{
	vector<st_PushStream*>::iterator it = m_vecPushStream.begin();
	for (; it != m_vecPushStream.end(); ++it)
	{
		st_PushStream* pPush = *it;
		if (pPush == NULL)
		{
			m_vecPushStream.erase(it);
			AddLog(LOG_LEVEL_ERROR,"[CMainViewDlg::PushStreamData] failed");
			return 0;
		}
		PushFile(pPush);
	}
	return 0;
}

unsigned int WINAPI CMainViewDlg::PushStramThread(LPVOID _Param)
{
	CMainViewDlg* pThis = (CMainViewDlg *)_Param;
	if (NULL == pThis)
	{
		return 1;
	}

	while (pThis->m_bRunPush)
	{
		pThis->LockPush();
		pThis->PushStreamData();
		pThis->UnlockPush();
		Sleep(1);
	}

	return 0;
}

void CMainViewDlg::ChangeAlarmState()
{
	CDC* dc = GetDC();
	CBrush* pOldBrush = NULL;

	for (int line = 0; line < PORT_ALARM_LINE; line++)
	{
		int iLeft = PORT_ALARM_BEGIN_LEFT;
		int iTop = PORT_ALARM_BEGIN_TOP + line*PORT_ALARM_ICON_SIZE;
		int iRight = PORT_ALARM_BEGIN_LEFT + PORT_ALARM_ICON_SIZE;
		int iBottom = iTop + PORT_ALARM_ICON_SIZE;

		for (int i = 0; i < DEC_MAX_PORT_NUM / PORT_ALARM_LINE; i++)
		{
			//4ƵλÿͿԺķֱǸ˿ڱ
			if (i % 4 == 0 && i != 0)
			{
				iLeft += PORT_ALARM_DISTANCE + 10;
			} 
			else
			{
				iLeft += PORT_ALARM_DISTANCE;
			}

			iRight = iLeft + PORT_ALARM_ICON_SIZE;

			if (m_iPortAlarm[i + line*DEC_MAX_PORT_NUM/PORT_ALARM_LINE] == 1)
			{
				pOldBrush = dc->SelectObject(&m_brAlarmColor);
			} 
			else
			{
				pOldBrush = dc->SelectObject(&m_brDisAlarmColor);
			}

			dc->Ellipse(iLeft, iTop, iRight, iBottom);
			dc->SelectObject(pOldBrush);
		}
	}

	
	ReleaseDC(dc);
}

void CMainViewDlg::OnPaint()
{
	CPaintDC dc(this); // device context for painting
	// TODO: Add your message handler code here
	ChangeAlarmState();

	// Do not call CDialog::OnPaint() for painting messages
}

int CMainViewDlg::ChangeAlarmNotify( int _iID )
{
	int iID = GetCurrentID();
	if (_iID == iID)
	{
		AlarmNotify stAlarmNotify = {0};

		for (int i = 0; i < DEC_MAX_PORT_NUM; i++)
		{
			stAlarmNotify.iBuffSize = sizeof(stAlarmNotify);
			stAlarmNotify.iAlarmType = 135;
			stAlarmNotify.iChannelNo = i;

			int iRet = DEC_ClientGetDevConfig(iID, -1, -1, CMD_DEC_CFG_ALARM_NOTIFY, &stAlarmNotify, sizeof(AlarmNotify));
			if (0 == iRet/*DEC_ClientGetDevConfig(iID, -1, -1, CMD_DEC_CFG_ALARM_NOTIFY, &stAlarmNotify, sizeof(stAlarmNotify))*/)
			{
				m_iPortAlarm[i] = stAlarmNotify.iState;
			}
			else
			{
				AddLog(LOG_LEVEL_WARN,"[CMainViewDlg::ChangeAlarmNotify][DEC_ClientGetDevConfig:CMD_DEC_CFG_ALARM_NOTIFY] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),_iID);
			}
		}

		CRect rect(PORT_ALARM_BEGIN_LEFT - 2, PORT_ALARM_BEGIN_TOP - 2, 
			PORT_ALARM_BEGIN_LEFT + PORT_ALARM_DISTANCE * DEC_MAX_PORT_NUM + 30, PORT_ALARM_BEGIN_TOP + PORT_ALARM_ICON_SIZE + 2);
		InvalidateRect(&rect);
	}

	return 0;
}

int CMainViewDlg::UpdataChannelState( int _iID )
{
	HTREEITEM hItem = FindItem(_iID);
	if (hItem == NULL)
	{
		return 0;
	}

	hItem = m_tvDecoder.GetChildItem(hItem);
	while(hItem)
	{
		int iChannelNo = (int)m_tvDecoder.GetItemData(hItem);
		if (iChannelNo < 0)
		{
			AddLog(LOG_LEVEL_ERROR, "iChannelNo < 0");
			break;
		}

		LocalChannelState stLocalChannelState = {0};
		stLocalChannelState.iBufSize = sizeof(LocalChannelState);
		stLocalChannelState.iChannelNo = iChannelNo;
		int iRet = DEC_ClientGetDevConfig(_iID, 0, 0, CMD_DEC_CFG_CHANN_STATE, &stLocalChannelState, sizeof(LocalChannelState));
		int iLocalChanState = STATE_CONNECT;
		if (iRet == 0)
		{	
			if (stLocalChannelState.iState == 0)
			{
				iLocalChanState = STATE_OFFLINE;	
			}
			else if (stLocalChannelState.iState == 1)
			{
				iLocalChanState = STATE_ONLINE;	
			}			
		}
		else
		{
			AddLog(LOG_LEVEL_WARN,"[CMainViewDlg::UpdataChannelState] DEC_ClientGetDevConfig failed!Ret(%d),Error(0x%08x),Type(%d)"
				, iRet, GetLastError(), CMD_DEC_CFG_CHANN_STATE);
		}
		//AddLog(LOG_LEVEL_DEBUG,"[CMainViewDlg::UpdataChannelState] iChannelNO %d iLocalChanState %d", iChannelNo, iLocalChanState);
		m_tvDecoder.SetItemImage(hItem, iLocalChanState, iLocalChanState);
		hItem=m_tvDecoder.GetNextSiblingItem(hItem);
	}

	return 0;
}


int CMainViewDlg::CreatevvoNotify( int _iID )
{
	HTREEITEM hItem = FindItem(_iID);
	if (hItem == NULL)
	{
		return 0;
	}

	DeleteAllChild(hItem);

	bool blUsedChannel[DEC_MAX_PHYSICAL_CHANNEL_NUM] = {false};
	bool blUsedScreen[DEC_MAX_SPLIT_CHANNEL_NUM] = {false};

	int iRet = 0;

	BaseOffset tGetStartAddress = {0};
	tGetStartAddress.iSize = sizeof(BaseOffset);
	iRet = DEC_ClientGetDevConfig(_iID, 0, 0, CMD_DEC_CFG_BASE_OFFSET, 
		&tGetStartAddress, sizeof(BaseOffset));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CLS_DlgSettingOSD::updatedialog][DEC_ClientGetDevConfig:CMD_DEC_CFG_BASE_OFFSET] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),_iID);
		return -1;
	}

	//ȡƴͨϢ
	CreateVVOInfo strCreateVVOInfo = {0};
	strCreateVVOInfo.iBufSize = sizeof(CreateVVOInfo);
	for (int i=0; i<DEC_MAX_SPLIT_CHANNEL_NUM; i++)
	{

		strCreateVVOInfo.iVVOChannelNo = i + tGetStartAddress.iSplitScreen;
		iRet = DEC_ClientGetDevConfig(_iID, 0, 0, CMD_DEC_CFG_CREATE_VVO, &strCreateVVOInfo, sizeof(CreateVVOInfo));
		if (ERR_SUCCESS != iRet)
		{
			AddLog(LOG_LEVEL_WARN,"[CMainViewDlg::CreatevvoNotify] Get decoder param failed!Ret(%d),Error(0x%08x),ID(%d)"
				,iRet,GetLastError(),_iID);
			continue;;
		}

		for (int j=0; j<(strCreateVVOInfo.iCols * strCreateVVOInfo.iRows) && j<DEC_MAX_PHYSICAL_CHANNEL_NUM; j++)
		{
			if (0 <= strCreateVVOInfo.iInputChannel[j] && strCreateVVOInfo.iInputChannel[j] < DEC_MAX_PHYSICAL_CHANNEL_NUM)
			{
				blUsedChannel[strCreateVVOInfo.iInputChannel[j]] = true;
			}

			blUsedScreen[i] = true;
		}
	}


	tDevInfo tDevInfomation = {0};
	iRet = DEC_ClientGetDevConfig(_iID, 0, 0, CMD_DEC_CFG_DEV_INFO, &tDevInfomation, sizeof(tDevInfo));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"DEC_ClientGetDevConfig");
		return -1;
	}

	CString strChanel;
	HTREEITEM hSubItem = NULL;

	//ͨ
	for (int i=0; i<tDevInfomation.iChanNum && i<DEC_MAX_PHYSICAL_CHANNEL_NUM; ++i)
	{
		if (!blUsedChannel[i])
		{
			//Get the state of local channel(online or not).
			LocalChannelState stLocalChannelState = {0};
			stLocalChannelState.iBufSize = sizeof(LocalChannelState);
			stLocalChannelState.iChannelNo = i;
			iRet = DEC_ClientGetDevConfig(_iID, 0, 0, CMD_DEC_CFG_CHANN_STATE, &stLocalChannelState, sizeof(LocalChannelState));
			int iLocalChanState = STATE_CONNECT;
			if (iRet == 0)
			{	
				if (stLocalChannelState.iState == 0)
				{
					iLocalChanState = STATE_OFFLINE;	
				}
				else if (stLocalChannelState.iState == 1)
				{
					iLocalChanState = STATE_ONLINE;	
				}			
			}
			else
			{
				AddLog(LOG_LEVEL_WARN,"[CMainViewDlg::CreatevvoNotify] DEC_ClientGetDevConfig failed!Ret(%d),Error(0x%08x),Type(%d)"
					, iRet, GetLastError(), CMD_DEC_CFG_CHANN_STATE);
			}

			strChanel.Format(_T("%s %d"),GetText(IDS_MAIN_CHANNEL),i+1);
			hSubItem = m_tvDecoder.InsertItem(strChanel,hItem);
			if (hSubItem)
			{
				m_tvDecoder.SetItemData(hSubItem,DWORD_PTR(i));
				m_tvDecoder.SetItemImage(hSubItem, iLocalChanState, iLocalChanState);
			}
		}
	}

	//ƴͨ
	for (int i=0; i<DEC_MAX_SPLIT_CHANNEL_NUM; i++)
	{
		if (blUsedScreen[i])
		{
			strChanel.Format(_T("%s %d"),GetText(IDS_SETTING_MULI_SCREEN_TITLE),i+1);
			hSubItem = m_tvDecoder.InsertItem(strChanel,hItem);
			if (hSubItem)
			{
				m_tvDecoder.SetItemData(hSubItem,DWORD_PTR(i+tGetStartAddress.iSplitScreen));
				m_tvDecoder.SetItemImage(hSubItem,STATE_CONNECT,STATE_CONNECT);
			}
		}
	}

	hSubItem = m_tvDecoder.GetChildItem(hItem);
	if (hSubItem)
	{
		m_tvDecoder.Expand(hItem,TVE_EXPAND);
		m_tvDecoder.SelectItem(hSubItem);
		int iChannel = (int)m_tvDecoder.GetItemData(hSubItem);
		int iPos = m_cboPos.GetCurSel();
		UpdateChannelInfo(_iID,iChannel,iPos);
	}

	return 0;		
}

BOOL CMainViewDlg::PreTranslateMessage(MSG* pMsg)
{
	if(pMsg->message == WM_KEYDOWN && (pMsg->wParam == VK_RETURN||pMsg->wParam == VK_ESCAPE)) 
	{ 
		return true;
	}

	return CDialog::PreTranslateMessage(pMsg);
}

LRESULT CMainViewDlg::WindowProc(UINT message, WPARAM wParam, LPARAM lParam)
{
	// TODO: Add your specialized code here and/or call the base class
	switch(message)
	{
	case WM_NCPAINT:	//СлtabҳȴϢؼ
		{
			Invalidate();
		}
		break;
	default:
		break;
	} 

	return CDialog::WindowProc(message, wParam, lParam);
}

void CMainViewDlg::OnBnClickedBtnSetUp()
{
	// TODO: ڴӿؼ֪ͨ
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	int iPos = GetCurrentPos();

	WindowSequence tSetSequence;
	tSetSequence.iSize = sizeof(WindowSequence);
	tSetSequence.iSequence = SET_TOP;
	int iRet = DEC_ClientSetDevConfig(iID, iChannel, iPos, 
		CMD_DEC_CFG_WINDOW_SEQUENCE, &tSetSequence, sizeof(WindowSequence));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CMainViewDlg::OnBnClickedBtnSetUp][DEC_ClientSetDevConfig:CMD_DEC_CFG_WINDOW_SEQUENCE] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),iID);
	}
}

void CMainViewDlg::OnBnClickedBtnSetDown()
{
	// TODO: ڴӿؼ֪ͨ
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	int iPos = GetCurrentPos();
	/*int iMode = 0;
	int iRet = -1;
	iRet = DEC_ClientGetDevConfig(iID, iChannel, 0, CMD_DEC_CFG_PICNUM, &iMode, sizeof(int));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CMainViewDlg::OnBnClickedBtnSetDown][DEC_ClientGetDevConfig:CMD_DEC_CFG_PICNUM] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),iID);
	}
	BaseOffset tGetStartAddress;
	iRet = DEC_ClientGetDevConfig(iID, 0, 0, CMD_DEC_CFG_BASE_OFFSET, 
		&tGetStartAddress, sizeof(BaseOffset));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CMainViewDlg::OnBnClickedBtnSetDown][DEC_ClientGetDevConfig:CMD_DEC_CFG_BASE_OFFSET] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),iID);
	}
	if(iPos >= iMode)
		iPos = iPos - iMode + tGetStartAddress.iFloatWindow;*/
	WindowSequence tSetSequence;
	tSetSequence.iSize = sizeof(WindowSequence);
	tSetSequence.iSequence = SET_DOWN;
	int iRet = DEC_ClientSetDevConfig(iID, iChannel, iPos, 
		CMD_DEC_CFG_WINDOW_SEQUENCE, &tSetSequence, sizeof(WindowSequence));
	if(iRet < 0)
	{
		AddLog(LOG_LEVEL_WARN,"[CMainViewDlg::OnBnClickedBtnSetDown][DEC_ClientSetDevConfig:CMD_DEC_CFG_WINDOW_SEQUENCE] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),iID);
	}
}

void CMainViewDlg::LockPush()
{
	EnterCriticalSection(&m_csPush);
}

void CMainViewDlg::UnlockPush()
{
	LeaveCriticalSection(&m_csPush);
}

int CMainViewDlg::InnerStartpPush(st_PushStream* tPush)
{
	if (tPush == NULL)
	{
		AddLog(LOG_LEVEL_DEBUG,"tPush == NULL");
		return -1;
	}

	tPush->m_bStart = TRUE;
	LockPush();
	AddPush(tPush);
	UnlockPush();
	return 0;
}

int CMainViewDlg::InnerStopPush(st_PushStream* _pStream)
{
	if (_pStream == NULL)
	{
		AddLog(LOG_LEVEL_DEBUG,"tStream == NULL");
		return -1;;
	}

	DeletePush(_pStream);
	int iShowLastPic = m_chkLastFrame.GetCheck();
	DEC_ClientStopPushStreamEx(_pStream->m_lPushID, iShowLastPic);
	_pStream->m_lPushID = -1;
	_pStream->m_bStart = FALSE;
	_pStream->m_iSpeed = 0;
	_pStream->m_bFlagAudio = false;
	if (_pStream->m_pFile != NULL)
	{
		delete _pStream->m_pFile;
		_pStream->m_pFile = NULL;
	}
	return 0;
}

st_PushStream* CMainViewDlg::FindPushStream(int _iID, int _iPushID)
{
	st_Decoder* ptDecoder = GetDecoder(_iID);
	if (ptDecoder == NULL)
	{
		AddLog(LOG_LEVEL_DEBUG,"ptDecoder == NULL");
		return NULL;
	}

	for(int j=0; j<(DEC_MAX_CHANNEL_TOTAL_NUM); ++j)
	{
		for(int k=0; k<DEC_MAX_WINDOW_TOTAL_NUM; ++k)
		{
			st_PushStream& tPush = ptDecoder->m_stPush[j][k];
			if (tPush.m_lPushID == _iPushID)
			{
				return &tPush;
			}
		}
	}

	return NULL;
}

int CMainViewDlg::PushStreamNotify(int _iID, int _iPushID,int _iStart)
{
	st_PushStream* tPush = FindPushStream(_iID, _iPushID);
	if (tPush == NULL)
	{
		AddLog(LOG_LEVEL_DEBUG,"[CMainViewDlg::PushStreamNotify] can not find push");
		return 0;
	}

	if (_iStart == 0)
	{
		InnerStopPush(tPush);
	}
	else
	{
		InnerStartpPush(tPush);
	}

	return 0;
}

int CMainViewDlg::InitPushStream()
{
	m_bRunPush = TRUE;
	if (m_hPushThread == NULL)
	{
		m_hPushThread = (HANDLE)_beginthreadex(NULL, 1024*1024*10, PushStramThread, (LPVOID)this, 0, &m_dwThreadID);
	}	
	return 0;
}

int CMainViewDlg::StopPushStream()
{
	m_bRunPush = FALSE;
	WaitForSingleObject(m_hPushThread, INFINITE);
	m_hPushThread = NULL;
	return 0;
}

int CMainViewDlg::DeletePush( st_PushStream* _pPush )
{
	if (_pPush == NULL)
	{
		AddLog(LOG_LEVEL_DEBUG,"[CMainViewDlg::DeletePush]_pPush == NULL");
		return -1;
	}
	LockPush();
	vector<st_PushStream*>::iterator it = m_vecPushStream.begin();
	int index = 0;
	for (; it != m_vecPushStream.end(); ++it)
	{
		st_PushStream* pPush = *it;
		if (_pPush == pPush)
		{
			m_vecPushStream.erase(it);
			break;
		}
	}
	UnlockPush();
	return 0;
}

int CMainViewDlg::AddPush( st_PushStream* _pPush )
{
	if (_pPush == NULL)
	{
		AddLog(LOG_LEVEL_DEBUG,"[CMainViewDlg::AddPush]_pPush == NULL");
		return -1;
	}
	AddLog(LOG_LEVEL_DEBUG,"[CMainViewDlg::AddPush]0 AddPush %d, 0x%08x,id %d ,chann %d, window %d", m_vecPushStream.size(), _pPush, _pPush->m_lPushID, _pPush->m_iChan, _pPush->m_iWindow);
	LockPush();
	m_vecPushStream.push_back(_pPush);
	UnlockPush();
	return 0;
}

LRESULT CMainViewDlg::OnFindDevice( WPARAM _WParam,LPARAM _LParam )
{
	st_Decoder* ptFindDevice = (st_Decoder*)_WParam;
	if (ptFindDevice == NULL)
	{
		AddLog(LOG_LEVEL_ERROR, "ptFindDevice == NULL");
		return -1;
	}

	AddDecoder(ptFindDevice);
	delete ptFindDevice;
	return 0;
}

void CMainViewDlg::UpdateSinglePicture()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	int iPos = GetCurrentPos();
	DecSinglePic tSinglePic = {0};
	tSinglePic.iSize = sizeof(DecSinglePic);
	int iRet = DEC_ClientGetDevConfig(iID, iChannel, -1, CMD_DEC_CFG_SINGLEPIC, &tSinglePic, sizeof(DecSinglePic));
	if(ERR_SUCCESS !=iRet)
	{
		AddLog(LOG_LEVEL_WARN,"[CMainViewDlg::UpdateSinglePicture][DEC_ClientGetDevConfig:CMD_DEC_CFG_SINGLEPIC] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),iID);
	}
	else
	{
		if (iPos == tSinglePic.iPicNum)
		{
			m_cboSinglePic.SetCurSel(tSinglePic.iState);
		}
	}
}

void CMainViewDlg::OnCbnSelchangeComboSignal()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	int iPos = GetCurrentPos();
	DecSinglePic tSinglePic = {0};
	tSinglePic.iSize = sizeof(DecSinglePic);
	tSinglePic.iState = m_cboSinglePic.GetCurSel();
	tSinglePic.iPicNum = iPos;
	int iRet = DEC_ClientSetDevConfig(iID, iChannel, -1, CMD_DEC_CFG_SINGLEPIC, &tSinglePic, sizeof(DecSinglePic));
	if(ERR_SUCCESS !=iRet)
	{
		AddLog(LOG_LEVEL_WARN,"[CMainViewDlg::OnCbnSelchangeComboSignal][DEC_ClientSetDevConfig:CMD_DEC_CFG_SINGLEPIC] failed!iRet(%d),Error(0x%08x),ID(%d)",iRet,GetLastError(),iID);
	}
}

void CMainViewDlg::OnScreen81()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();
	UpdateChannelMode(iID,iChannel, 81);
}

void CMainViewDlg::OnBnClickedButtonSdkWorkMode()
{
	int iSdkWorkMode = m_cboSdkWorkMode.GetCurSel();
	DEC_ClientSetSDKWorkMode(iSdkWorkMode);
}

void CMainViewDlg::OnBnClickedButtonSyncLoopctrl()
{
	int iID = GetCurrentID();
	int iChannel = GetCurrentChannel();

	int iRet = -1;
	int iSyncLoopStatus = 0;
	CString strSyncSwitch;
	GetDlgItemText(IDC_BUTTON_SYNC_LOOPCTRL, strSyncSwitch);
	if (0 == strSyncSwitch.CompareNoCase(GetText(IDS_MAIN_SYNCSWITCH)))
	{
		iSyncLoopStatus = 1;

		int iSyncLoopTime = GetDlgItemInt(IDC_EDIT_SYNC_LOOPTIME);
		DecSyncLoopTime tLoopTime = {0};
		tLoopTime.iSize = sizeof(DecSyncLoopTime);
		tLoopTime.iHoldTime = iSyncLoopTime;
		int iRet = DEC_ClientSetDevConfig(iID, iChannel, 0, CMD_DEC_CFG_SYNCLOOPTIME, &tLoopTime, sizeof(DecSyncLoopTime));
		if (ERR_SUCCESS != iRet)
		{
			AddLog(LOG_LEVEL_ERROR, "[CMainViewDlg::OnBnClickedButtonSyncLoopctrl] DEC_ClientSetDevConfig Failed! Ret(%d),CMDID(%d)",
				iRet, CMD_DEC_CFG_SYNCLOOPTIME);
		}
	}
	DecSyncLoopCtrl tLoopCtrl = {0};
	tLoopCtrl.iSize = sizeof(DecSyncLoopCtrl);
	tLoopCtrl.iLoopEnable = iSyncLoopStatus;
	iRet = DEC_ClientSetDevConfig(iID, iChannel, 0, CMD_DEC_CFG_SYNCLOOPCTRL, &tLoopCtrl, sizeof(DecSyncLoopCtrl));
	if (ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_ERROR, "[CMainViewDlg::UpdateSwitchStatus] DEC_ClientSetDevConfig Failed! Ret(%d),CMDID(%d)",
			iRet, CMD_DEC_CFG_SYNCLOOPCTRL);
	} 
}

void CMainViewDlg::OnBnClickedBtnPicsnap()
{
	// TODO: Add your control notification handler code here


	POSITION pos = m_lstNvs.GetFirstSelectedItemPosition();
	if (pos)
	{
		int iItem = m_lstNvs.GetNextSelectedItem(pos);
		if (iItem >= 0)
		{
			int iID = GetCurrentID();
			int iChannel = GetCurrentChannel();

			ViewServerInfo tViewServer = {0};
			GetNvsServer(iItem, tViewServer);
			
			PicSnap tPicSnap = {0};
			ConvertSeverToItem(&tViewServer,&tPicSnap.uServerItem,&tPicSnap.serType);

			int iRet = DEC_ClientSendCommand(iID, iChannel, 0, DEC_COMMAND_PICSNAP, &tPicSnap, sizeof(PicSnap));
			if (ERR_SUCCESS != iRet)
			{
				AddLog(LOG_LEVEL_ERROR, "[CMainViewDlg::OnBnClickedBtnPicsnap] DEC_ClientSendCommand Failed! Ret(%d),CMDID(DEC_COMMAND_PICSNAP)",iRet);
			}
			//ץĶԻ
			CLS_DlgPicSnap dlgPicsnap(this,-1);
			m_pDlgPicSnap = &dlgPicsnap;
			dlgPicsnap.DoModal();
			m_pDlgPicSnap = NULL;
		}
	}

}
void CMainViewDlg::PicsnapNotify(_MAIN_NOTIFY_DATA* _pData)
{
	if(NULL != m_pDlgPicSnap)
	{
		m_pDlgPicSnap->OnMainNotify(_pData);
	}
}

void CMainViewDlg::CmdPicSnap(int _iCmd,int _iSnapID)
{
	//ɾץ/ȡץļ
	PicSnapID tPicSnapID = {0};
	tPicSnapID.iSnapID = _iSnapID;
	int iRet = DEC_ClientSendCommand(GetCurrentID(), GetCurrentChannel(), 0, _iCmd, &tPicSnapID, sizeof(PicSnapID));
	if (ERR_SUCCESS != iRet)
	{
		AddLog(LOG_LEVEL_ERROR, "[CMainViewDlg::CmdPicSnap] DEC_ClientSendCommand Failed! Ret(%d),CMDID(%d)",iRet,_iCmd);
	}

}

